/*
 * Decompiled with CFR 0.152.
 */
package alexiil.mc.mod.pipes.util;

import com.mojang.blaze3d.systems.RenderSystem;
import javax.annotation.Nullable;
import net.fabricmc.fabric.api.client.rendering.v1.ColorProviderRegistry;
import net.minecraft.class_1792;
import net.minecraft.class_1935;
import net.minecraft.class_2248;
import net.minecraft.class_289;
import net.minecraft.class_310;
import net.minecraft.class_322;
import net.minecraft.class_326;

public final class RenderUtil {
    private static final ThreadLocal<TessellatorQueue> threadLocalTessellators = ThreadLocal.withInitial(TessellatorQueue::new);

    private RenderUtil() {
    }

    public static void registerBlockColour(@Nullable class_2248 block, class_322 colour) {
        if (block != null) {
            ColorProviderRegistry.BLOCK.register((Object)colour, (Object[])new class_2248[]{block});
        }
    }

    public static void registerItemColour(@Nullable class_1792 item, class_326 colour) {
        if (item != null) {
            ColorProviderRegistry.ITEM.register((Object)colour, (Object[])new class_1935[]{item});
        }
    }

    public static void registerItemColour(@Nullable class_1792 item) {
        RenderUtil.registerItemColour(item, (stack, c) -> c == 0 ? -1 : c);
    }

    public static void setGLColorFromInt(int color) {
        float red = (float)(color >> 16 & 0xFF) / 255.0f;
        float green = (float)(color >> 8 & 0xFF) / 255.0f;
        float blue = (float)(color & 0xFF) / 255.0f;
        RenderSystem.setShaderColor((float)red, (float)green, (float)blue, (float)1.0f);
    }

    public static void setGLColorFromIntPlusAlpha(int color) {
        float alpha = (float)(color >>> 24 & 0xFF) / 255.0f;
        float red = (float)(color >> 16 & 0xFF) / 255.0f;
        float green = (float)(color >> 8 & 0xFF) / 255.0f;
        float blue = (float)(color & 0xFF) / 255.0f;
        RenderSystem.setShaderColor((float)red, (float)green, (float)blue, (float)alpha);
    }

    public static int swapARGBforABGR(int argb) {
        int a = argb >>> 24 & 0xFF;
        int r = argb >> 16 & 0xFF;
        int g = argb >> 8 & 0xFF;
        int b = argb >> 0 & 0xFF;
        return a << 24 | b << 16 | g << 8 | r;
    }

    public static boolean isRenderingTranslucent() {
        return false;
    }

    public static boolean isMainRenderThread() {
        return class_310.method_1551().method_18854();
    }

    public static AutoTessellator getThreadLocalUnusedTessellator() {
        return threadLocalTessellators.get().nextFreeTessellator();
    }

    private static class_289 newTessellator() {
        return new class_289(0x200000);
    }

    static class TessellatorQueue {
        private static final int BUFFER_COUNT = 20;
        final class_289[] tessellators = new class_289[20];
        final boolean[] tessellatorInUse = new boolean[20];

        TessellatorQueue() {
        }

        AutoTessellator nextFreeTessellator() {
            for (int i = 0; i < this.tessellators.length; ++i) {
                if (this.tessellatorInUse[i]) continue;
                class_289 tess = this.tessellators[i];
                if (tess == null) {
                    this.tessellators[i] = tess = RenderUtil.newTessellator();
                }
                return new AutoTessellator(this, i);
            }
            throw new Error("Too many tessellators! Has a caller not finished with one of them?");
        }
    }

    public static final class AutoTessellator
    implements AutoCloseable {
        private final TessellatorQueue queue;
        private final int index;
        public final class_289 tessellator;

        public AutoTessellator(TessellatorQueue queue, int index) {
            this.queue = queue;
            this.index = index;
            this.tessellator = queue.tessellators[index];
            queue.tessellatorInUse[index] = true;
        }

        @Override
        public void close() {
            this.queue.tessellatorInUse[this.index] = false;
        }
    }
}

