/*
 * Decompiled with CFR 0.152.
 */
package alexiil.mc.mod.pipes.pipe;

import alexiil.mc.lib.attributes.item.ItemStackUtil;
import alexiil.mc.lib.net.IMsgReadCtx;
import alexiil.mc.lib.net.IMsgWriteCtx;
import alexiil.mc.lib.net.NetByteBuf;
import alexiil.mc.mod.pipes.pipe.ISimplePipe;
import alexiil.mc.mod.pipes.util.TagUtil;
import io.netty.buffer.ByteBuf;
import java.util.EnumSet;
import javax.annotation.Nonnull;
import net.minecraft.class_1767;
import net.minecraft.class_1799;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_7225;
import net.minecraft.class_9129;

public class TravellingItem {
    public class_1767 colour;
    @Nonnull
    public class_1799 stack;
    int id = 0;
    boolean toCenter;
    double speed = 0.05;
    long tickStarted;
    long tickFinished;
    int timeToDest;
    class_2350 side;
    EnumSet<class_2350> tried = EnumSet.noneOf(class_2350.class);
    boolean isPhantom = false;

    public TravellingItem(@Nonnull class_1799 stack) {
        this.stack = stack;
    }

    public TravellingItem(class_2487 nbt, class_7225.class_7874 lookup, long tickNow) {
        this.stack = ItemStackUtil.fromNbt((class_2520)nbt.method_10562("stack"), (class_7225.class_7874)lookup);
        byte c = nbt.method_10571("colour");
        this.colour = c == 0 ? null : class_1767.method_7791((int)(c - 1));
        this.toCenter = nbt.method_10577("toCenter");
        this.speed = nbt.method_10574("speed");
        if (this.speed < 0.001) {
            this.speed = 0.001;
        }
        this.tickStarted = (long)nbt.method_10550("tickStarted") + tickNow;
        this.tickFinished = (long)nbt.method_10550("tickFinished") + tickNow;
        this.timeToDest = nbt.method_10550("timeToDest");
        this.side = TagUtil.readEnum(nbt.method_10580("side"), class_2350.class);
        if (this.side == null || this.timeToDest == 0) {
            this.toCenter = true;
        }
        this.tried = TagUtil.readEnumSet(nbt.method_10580("tried"), class_2350.class);
        this.isPhantom = nbt.method_10577("isPhantom");
    }

    public TravellingItem(NetByteBuf buf, IMsgReadCtx ctx, long tickNow) {
        this.stack = buf.readBoolean() ? (class_1799)class_1799.field_48349.decode((Object)new class_9129((ByteBuf)buf, ctx.getConnection().getPlayer().method_56673())) : class_1799.field_8037;
        byte c = buf.readByte();
        this.colour = c == 0 ? null : class_1767.method_7791((int)(c - 1));
        this.toCenter = buf.readBoolean();
        this.speed = buf.readDouble();
        if (this.speed < 0.001) {
            this.speed = 0.001;
        }
        this.tickStarted = (long)buf.readVarUnsignedInt() + tickNow;
        this.tickFinished = (long)buf.readVarUnsignedInt() + tickNow;
        this.timeToDest = buf.readVarUnsignedInt();
        this.side = (class_2350)buf.method_10818(class_2350.class);
        this.tried = buf.method_46251(class_2350.class);
        this.isPhantom = buf.readBoolean();
    }

    public class_2487 writeToNbt(class_7225.class_7874 lookup, long tickNow) {
        class_2487 nbt = new class_2487();
        nbt.method_10566("stack", ItemStackUtil.writeNbt((class_1799)this.stack, (class_7225.class_7874)lookup));
        nbt.method_10567("colour", (byte)(this.colour == null ? 0 : this.colour.method_7789() + 1));
        nbt.method_10556("toCenter", this.toCenter);
        nbt.method_10549("speed", this.speed);
        nbt.method_10569("tickStarted", (int)(this.tickStarted - tickNow));
        nbt.method_10569("tickFinished", (int)(this.tickFinished - tickNow));
        nbt.method_10569("timeToDest", this.timeToDest);
        nbt.method_10566("side", TagUtil.writeEnum(this.side));
        nbt.method_10566("tried", TagUtil.writeEnumSet(this.tried, class_2350.class));
        if (this.isPhantom) {
            nbt.method_10556("isPhantom", true);
        }
        return nbt;
    }

    public void writeToBuffer(NetByteBuf buf, IMsgWriteCtx ctx, long tickNow) {
        if (this.stack.method_7960()) {
            buf.writeBoolean(false);
        } else {
            buf.writeBoolean(true);
            class_1799.field_48349.encode((Object)new class_9129((ByteBuf)buf, ctx.getConnection().getPlayer().method_56673()), (Object)this.stack);
        }
        buf.method_52997((int)((byte)(this.colour == null ? 0 : this.colour.method_7789() + 1)));
        buf.writeBoolean(this.toCenter);
        buf.method_52940(this.speed);
        buf.writeVarUnsignedInt((int)(this.tickStarted - tickNow));
        buf.writeVarUnsignedInt((int)(this.tickFinished - tickNow));
        buf.writeVarUnsignedInt(this.timeToDest);
        buf.writeEnumConstant((Enum)this.side);
        buf.method_46253(this.tried, class_2350.class);
        buf.writeBoolean(this.isPhantom);
    }

    public int getCurrentDelay(long tickNow) {
        long diff = this.tickFinished - tickNow;
        if (diff < 0L) {
            return 0;
        }
        return (int)diff;
    }

    public double getWayThrough(long now) {
        long diff = this.tickFinished - this.tickStarted;
        long nowDiff = now - this.tickStarted;
        return (double)nowDiff / (double)diff;
    }

    public void genTimings(long now, double distance) {
        this.tickStarted = now;
        this.timeToDest = (int)Math.ceil(distance / this.speed);
        this.tickFinished = now + (long)this.timeToDest;
    }

    public boolean canMerge(TravellingItem with) {
        if (this.isPhantom || with.isPhantom) {
            return false;
        }
        return this.toCenter == with.toCenter && this.colour == with.colour && this.side == with.side && Math.abs(this.tickFinished - with.tickFinished) < 4L && this.stack.method_7914() >= this.stack.method_7947() + with.stack.method_7947() && ItemStackUtil.areEqualIgnoreAmounts((class_1799)this.stack, (class_1799)with.stack);
    }

    public boolean mergeWith(TravellingItem with) {
        if (this.canMerge(with)) {
            this.stack.method_7933(with.stack.method_7947());
            return true;
        }
        return false;
    }

    public class_243 interpolatePosition(class_243 start, class_243 end, long tick, float partialTicks) {
        long diff = this.tickFinished - this.tickStarted;
        long nowDiff = tick - this.tickStarted;
        double sinceStart = (float)nowDiff + partialTicks;
        double interpMul = sinceStart / (double)diff;
        double oneMinus = 1.0 - interpMul;
        if (interpMul <= 0.0) {
            return start;
        }
        if (interpMul >= 1.0) {
            return end;
        }
        double x = oneMinus * start.field_1352 + interpMul * end.field_1352;
        double y = oneMinus * start.field_1351 + interpMul * end.field_1351;
        double z = oneMinus * start.field_1350 + interpMul * end.field_1350;
        return new class_243(x, y, z);
    }

    public class_243 getRenderPosition(class_2338 pos, long tick, float partialTicks, ISimplePipe pipe) {
        class_243 vecTo;
        class_243 vecFrom;
        class_243 vecSide;
        long diff = this.tickFinished - this.tickStarted;
        long afterTick = tick - this.tickStarted;
        float interp = ((float)afterTick + partialTicks) / (float)diff;
        interp = Math.max(0.0f, Math.min(1.0f, interp));
        class_243 center = class_243.method_24954((class_2382)pos).method_1031(0.5, 0.5, 0.5);
        class_243 class_2432 = vecSide = this.side == null ? center : center.method_1019(class_243.method_24954((class_2382)this.side.method_10163()).method_1021(pipe.getPipeLength(this.side)));
        if (this.toCenter) {
            vecFrom = vecSide;
            vecTo = center;
        } else {
            vecFrom = center;
            vecTo = vecSide;
        }
        return vecFrom.method_1021((double)(1.0f - interp)).method_1019(vecTo.method_1021((double)interp));
    }

    public class_2350 getRenderDirection(long tick, float partialTicks) {
        long diff = this.tickFinished - this.tickStarted;
        long afterTick = tick - this.tickStarted;
        float interp = ((float)afterTick + partialTicks) / (float)diff;
        interp = Math.max(0.0f, Math.min(1.0f, interp));
        if (this.toCenter) {
            return this.side == null ? null : this.side.method_10153();
        }
        return this.side;
    }

    public boolean isVisible() {
        return true;
    }
}

