/*
 * Decompiled with CFR 0.152.
 */
package alexiil.mc.mod.pipes.pipe;

import alexiil.mc.lib.attributes.Simulation;
import alexiil.mc.lib.attributes.item.ItemInsertable;
import alexiil.mc.lib.attributes.item.filter.ConstantItemFilter;
import alexiil.mc.lib.attributes.item.filter.ItemFilter;
import alexiil.mc.lib.attributes.item.impl.EmptyItemExtractable;
import alexiil.mc.lib.attributes.item.impl.RejectingItemInsertable;
import alexiil.mc.lib.multipart.api.AbstractPart;
import alexiil.mc.lib.net.IMsgReadCtx;
import alexiil.mc.lib.net.IMsgWriteCtx;
import alexiil.mc.lib.net.InvalidInputDataException;
import alexiil.mc.lib.net.NetByteBuf;
import alexiil.mc.mod.pipes.part.SimplePipeParts;
import alexiil.mc.mod.pipes.pipe.ISimplePipe;
import alexiil.mc.mod.pipes.pipe.PipeSpDef;
import alexiil.mc.mod.pipes.pipe.PipeSpFlow;
import alexiil.mc.mod.pipes.pipe.TravellingItem;
import alexiil.mc.mod.pipes.util.DelayedList;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.class_1297;
import net.minecraft.class_1542;
import net.minecraft.class_1767;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2371;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_4990;
import net.minecraft.class_7225;
import net.minecraft.class_8567;
import net.minecraft.class_9129;

public class PipeSpFlowItem
extends PipeSpFlow {
    private static final int MAX_ITEMS_SENT_TO_CLIENT = 64;
    final ItemInsertable[] insertables;
    private final DelayedList<TravellingItem> items = new DelayedList();

    public PipeSpFlowItem(ISimplePipe pipe) {
        super(pipe);
        this.insertables = new ItemInsertable[6];
        for (final class_2350 dir : class_2350.values()) {
            this.insertables[dir.method_10153().ordinal()] = new ItemInsertable(){

                public class_1799 attemptInsertion(class_1799 stack, Simulation simulation) {
                    if (stack.method_7960()) {
                        return stack;
                    }
                    return PipeSpFlowItem.this.injectItem(stack, simulation.isAction(), dir, null, 0.04);
                }

                public ItemFilter getInsertionFilter() {
                    return ConstantItemFilter.ANYTHING;
                }
            };
        }
    }

    @Override
    public void fromTag(class_2487 tag, class_7225.class_7874 lookup) {
        class_2499 list = tag.method_10554("items", (int)new class_2487().method_10711());
        for (int i = 0; i < list.size(); ++i) {
            TravellingItem item = new TravellingItem(list.method_10602(i), lookup, 0L);
            if (item.stack.method_7960()) continue;
            this.items.add(item.getCurrentDelay(0L), item);
        }
    }

    @Override
    public class_2487 toTag(class_7225.class_7874 lookup) {
        class_2487 nbt = new class_2487();
        List<List<TravellingItem>> allItems = this.items.getAllElements();
        class_2499 list = new class_2499();
        long tickNow = this.pipe.getWorldTime();
        for (Iterable iterable : allItems) {
            if (iterable == null) continue;
            for (TravellingItem item : iterable) {
                list.add((Object)item.writeToNbt(lookup, tickNow));
            }
        }
        nbt.method_10566("items", (class_2520)list);
        return nbt;
    }

    @Override
    public void fromBuffer(NetByteBuf buffer, IMsgReadCtx ctx) throws InvalidInputDataException {
        this.items.clear();
        int itemCount = buffer.readVarUnsignedInt();
        for (int i = 0; i < itemCount; ++i) {
            TravellingItem item = new TravellingItem(buffer, ctx, 0L);
            if (item.stack.method_7960()) continue;
            this.items.add(item.getCurrentDelay(0L), item);
        }
    }

    @Override
    public void writeToBuffer(NetByteBuf buffer, IMsgWriteCtx ctx) {
        List allItems = this.items.getAllElements().stream().reduce(Lists.newArrayList(), (result, element) -> {
            if (element != null) {
                result.addAll(element);
            }
            return result;
        });
        long tickNow = this.pipe.getWorldTime();
        int itemCount = Math.min(allItems.size(), 64);
        buffer.writeVarUnsignedInt(itemCount);
        for (int i = 0; i < itemCount; ++i) {
            ((TravellingItem)allItems.get(i)).writeToBuffer(buffer, ctx, tickNow);
        }
    }

    @Override
    public void fromClientTag(NetByteBuf buffer, IMsgReadCtx ctx) {
        TravellingItem item = new TravellingItem((class_1799)class_1799.field_48349.decode((Object)new class_9129((ByteBuf)buffer, ctx.getConnection().getPlayer().method_56673())));
        item.toCenter = buffer.readBoolean();
        item.side = (class_2350)buffer.method_10818(class_2350.class);
        item.colour = buffer.readBoolean() ? (class_1767)buffer.method_10818(class_1767.class) : null;
        item.timeToDest = Short.toUnsignedInt(buffer.readShort());
        item.tickStarted = this.pipe.getWorldTime() + 1L;
        item.tickFinished = item.tickStarted + (long)item.timeToDest;
        item.speed *= this.getSpeedModifier();
        this.items.add(item.timeToDest + 1, item);
    }

    void sendItemDataToClient(TravellingItem item) {
        if (item.stack.method_7960()) {
            return;
        }
        this.pipe.sendFlowPacket((buf, ctx) -> {
            class_1799.field_48349.encode((Object)new class_9129((ByteBuf)buf, this.world().method_30349()), (Object)item.stack);
            buf.writeBoolean(item.toCenter);
            buf.writeEnumConstant((Enum)item.side);
            if (item.colour != null) {
                buf.writeBoolean(true);
                buf.writeEnumConstant((Enum)item.colour);
            } else {
                buf.writeBoolean(false);
            }
            buf.method_52998((int)((short)(item.timeToDest > Short.MAX_VALUE ? Short.MAX_VALUE : (short)item.timeToDest)));
        });
    }

    @Override
    public Object getInsertable(class_2350 searchDirection) {
        return this.insertables[searchDirection.method_10146()];
    }

    @Override
    public boolean hasInsertable(class_2350 dir) {
        return this.pipe.getItemInsertable(dir) != RejectingItemInsertable.NULL;
    }

    @Override
    public boolean hasExtractable(class_2350 dir) {
        return this.pipe.getItemExtractable(dir) != EmptyItemExtractable.NULL;
    }

    @Override
    public void tick() {
        class_1937 w = this.pipe.getPipeWorld();
        if (w == null) {
            return;
        }
        List<TravellingItem> toTick = this.items.advance();
        if (toTick == null) {
            return;
        }
        long currentTime = this.pipe.getWorldTime();
        for (TravellingItem item : toTick) {
            if (item.tickFinished > currentTime) {
                this.items.add((int)(item.tickFinished - currentTime), item);
                continue;
            }
            if (item.isPhantom || w.field_9236) continue;
            if (item.toCenter) {
                this.onItemReachCenter(item);
                continue;
            }
            this.onItemReachEnd(item);
        }
    }

    @Override
    public void addDrops(AbstractPart.ItemDropTarget target, class_8567 context) {
        class_2338 pos = this.pipe.getPipePos();
        long tick = this.pipe.getWorldTime();
        for (Iterable iterable : this.items.getAllElements()) {
            if (iterable == null) continue;
            for (TravellingItem travel : iterable) {
                if (travel.isPhantom) continue;
                target.drop(travel.stack, travel.getRenderPosition(pos, tick, 1.0f, this.pipe), class_243.field_1353);
            }
        }
    }

    @Override
    public void removeItemsForDrop(class_2371<class_1799> all) {
        for (Iterable iterable : this.items.getAllElements()) {
            if (iterable == null) continue;
            for (TravellingItem travel : iterable) {
                if (travel.isPhantom) continue;
                all.add((Object)travel.stack);
            }
        }
        this.items.clear();
    }

    @Override
    public void transform(class_4990 transformation) {
        for (Iterable iterable : this.items.getAllElements()) {
            if (iterable == null) continue;
            for (TravellingItem item : iterable) {
                item.side = transformation.method_26388(item.side);
                EnumSet<class_2350> oldTried = EnumSet.copyOf(item.tried);
                item.tried.clear();
                for (class_2350 tried : oldTried) {
                    item.tried.add(transformation.method_26388(tried));
                }
            }
        }
    }

    protected List<EnumSet<class_2350>> getOrderForItem(TravellingItem item, EnumSet<class_2350> validDirections) {
        ArrayList<EnumSet<class_2350>> list = new ArrayList<EnumSet<class_2350>>();
        if (this.pipe.getDefinition() == SimplePipeParts.CLAY_PIPE_FLUIDS || this.pipe.getDefinition() == SimplePipeParts.CLAY_PIPE_ITEMS) {
            EnumSet<class_2350> invs = EnumSet.noneOf(class_2350.class);
            EnumSet<class_2350> others = EnumSet.noneOf(class_2350.class);
            for (class_2350 dir : validDirections) {
                if (this.pipe.getNeighbourPipe(dir) != null) {
                    others.add(dir);
                    continue;
                }
                invs.add(dir);
            }
            list.add(invs);
            list.add(others);
        } else if (!validDirections.isEmpty()) {
            list.add(validDirections);
        }
        return list;
    }

    protected boolean canBounce() {
        return ((PipeSpDef.PipeDefItem)this.pipe.getDefinition()).canBounce;
    }

    protected double getSpeedModifier() {
        return ((PipeSpDef.PipeDefItem)this.pipe.getDefinition()).speedModifier;
    }

    private void onItemReachCenter(TravellingItem item) {
        if (item.stack.method_7960()) {
            return;
        }
        EnumSet<class_2350> dirs = EnumSet.allOf(class_2350.class);
        dirs.remove(item.side);
        dirs.removeAll(item.tried);
        for (class_2350 dir : class_2350.values()) {
            if (this.pipe.isConnected(dir) && this.pipe.getItemInsertable(dir) != null) continue;
            dirs.remove(dir);
        }
        ImmutableList order = this.getOrderForItem(item, dirs);
        if (order.isEmpty()) {
            if (this.canBounce()) {
                order = ImmutableList.of(EnumSet.of(item.side));
            } else {
                this.dropItem(item.stack, null, item.side.method_10153(), item.speed);
                return;
            }
        }
        long now = this.pipe.getWorldTime();
        double newSpeed = 0.08 * this.getSpeedModifier();
        ArrayList destinations = new ArrayList();
        for (EnumSet set : order) {
            ArrayList shuffled = new ArrayList();
            shuffled.addAll(set);
            Collections.shuffle(shuffled);
            destinations.addAll(shuffled);
        }
        if (destinations.size() == 0) {
            this.dropItem(item.stack, null, item.side.method_10153(), newSpeed);
        } else {
            TravellingItem newItem = new TravellingItem(item.stack);
            newItem.tried.addAll(item.tried);
            newItem.toCenter = false;
            newItem.colour = item.colour;
            newItem.side = (class_2350)destinations.get(0);
            newItem.speed = newSpeed;
            newItem.genTimings(now, this.pipe.getPipeLength(newItem.side));
            this.items.add(newItem.timeToDest, newItem);
            this.sendItemDataToClient(newItem);
        }
    }

    private void onItemReachEnd(TravellingItem item) {
        ItemInsertable ins = this.pipe.getItemInsertable(item.side);
        class_1799 excess = item.stack;
        if (ins != null) {
            class_2350 oppositeSide = item.side.method_10153();
            ISimplePipe oPipe = this.pipe.getNeighbourPipe(item.side);
            excess = oPipe != null && oPipe.getFlow() instanceof PipeSpFlowItem ? ((PipeSpFlowItem)oPipe.getFlow()).injectItem(excess, true, oppositeSide, item.colour, item.speed) : ins.attemptInsertion(excess, Simulation.ACTION);
        }
        if (excess.method_7960()) {
            return;
        }
        item.tried.add(item.side);
        item.toCenter = true;
        item.stack = excess;
        item.genTimings(this.pipe.getWorldTime(), this.pipe.getPipeLength(item.side));
        this.items.add(item.timeToDest, item);
        this.sendItemDataToClient(item);
    }

    private void dropItem(class_1799 stack, class_2350 side, class_2350 motion, double speed) {
        if (stack == null || stack.method_7960()) {
            return;
        }
        double x = (double)this.pipe.getPipePos().method_10263() + 0.5 + (double)motion.method_10148() * 0.5;
        double y = (double)this.pipe.getPipePos().method_10264() + 0.5 + (double)motion.method_10164() * 0.5;
        double z = (double)this.pipe.getPipePos().method_10260() + 0.5 + (double)motion.method_10165() * 0.5;
        speed += 0.01;
        class_1542 ent = new class_1542(this.world(), x, y, z, stack);
        ent.method_18799(class_243.method_24954((class_2382)motion.method_10163()).method_1021(speed *= 2.0));
        this.world().method_8649((class_1297)ent);
    }

    public boolean canInjectItems(class_2350 from) {
        return this.pipe.isConnected(from);
    }

    public class_1799 injectItem(@Nonnull class_1799 stack, boolean doAdd, class_2350 from, class_1767 colour, double speed) {
        if (this.world().field_9236) {
            throw new IllegalStateException("Cannot inject items on the client side!");
        }
        if (!this.canInjectItems(from)) {
            return stack;
        }
        if (speed < 0.01) {
            speed = 0.01;
        }
        class_1799 toSplit = class_1799.field_8037;
        class_1799 toInsert = stack;
        if (doAdd) {
            this.insertItemEvents(toInsert, colour, speed, from);
        }
        if (toSplit.method_7960()) {
            toSplit = class_1799.field_8037;
        }
        return toSplit;
    }

    public void insertItemsForce(@Nonnull class_1799 stack, class_2350 from, class_1767 colour, double speed) {
        if (this.world().field_9236) {
            throw new IllegalStateException("Cannot inject items on the client side!");
        }
        if (stack.method_7960()) {
            return;
        }
        if (speed < 0.01) {
            speed = 0.01;
        }
        long now = this.pipe.getWorldTime();
        TravellingItem item = new TravellingItem(stack);
        item.side = from;
        item.toCenter = true;
        item.speed = speed;
        item.colour = colour;
        item.genTimings(now, 0.0);
        item.tried.add(from);
        this.addItemTryMerge(item);
    }

    private void insertItemEvents(@Nonnull class_1799 toInsert, class_1767 colour, double speed, class_2350 from) {
        long now = this.world().method_8510();
        TravellingItem item = new TravellingItem(toInsert);
        item.side = from;
        item.toCenter = true;
        item.speed = speed;
        item.colour = colour;
        item.stack = toInsert;
        item.genTimings(now, this.pipe.getPipeLength(from));
        item.tried.add(from);
        this.addItemTryMerge(item);
    }

    private void addItemTryMerge(TravellingItem item) {
        this.items.add(item.timeToDest, item);
        this.sendItemDataToClient(item);
    }

    @Nullable
    private static EnumSet<class_2350> getFirstNonEmptySet(List<EnumSet<class_2350>> possible) {
        for (EnumSet<class_2350> set : possible) {
            if (set.size() <= 0) continue;
            return set;
        }
        return null;
    }

    public List<TravellingItem> getAllItemsForRender() {
        ArrayList<TravellingItem> all = new ArrayList<TravellingItem>();
        for (List<TravellingItem> innerList : this.items.getAllElements()) {
            all.addAll(innerList);
        }
        return all;
    }
}

