/*
 * Decompiled with CFR 0.152.
 */
package alexiil.mc.mod.pipes.pipe;

import alexiil.mc.lib.attributes.fluid.volume.ColouredFluidVolume;
import alexiil.mc.lib.attributes.fluid.volume.FluidKeys;
import alexiil.mc.lib.attributes.fluid.volume.FluidVolume;
import alexiil.mc.mod.pipes.pipe.PartSpPipe;
import alexiil.mc.mod.pipes.pipe.PipeSpBehaviour;
import alexiil.mc.mod.pipes.pipe.PipeSpFlowFluid;

public class PipeSpBehaviourSponge
extends PipeSpBehaviour {
    public static final float RED = 0.625f;
    public static final float GREEN = 0.8125f;
    public static final float BLUE = 1.0f;
    public static final float ALPHA = 0.75f;
    private static final float RED_SQ = 0.390625f;
    private static final float GREEN_SQ = 0.66015625f;
    private static final float BLUE_SQ = 1.0f;
    private static final float ALPHA_SQ = 0.5625f;

    public PipeSpBehaviourSponge(PartSpPipe pipe) {
        super(pipe);
    }

    @Override
    public void tick() {
        super.tick();
        PipeSpBehaviourSponge.tickFluid((PipeSpFlowFluid)this.pipe.getFlow());
    }

    public static void tickFluid(PipeSpFlowFluid f) {
        FluidVolume fluid = f.centerSection.getFluid();
        if (fluid.isEmpty()) {
            return;
        }
        if (FluidKeys.WATER.equals((Object)fluid.getFluidKey())) {
            ColouredFluidVolume vol = (ColouredFluidVolume)fluid;
            double r = vol.getRed();
            double g = vol.getGreen();
            double b = vol.getBlue();
            double a = vol.getAlpha();
            if (r == 0.625 && g == 0.8125 && b == 1.0 && a == 0.75) {
                return;
            }
            double allowedChange = 1.0 / vol.amount().asInexactDouble() / 20.0;
            if (allowedChange < 0.002) {
                allowedChange = 0.002;
            }
            r *= r;
            g *= g;
            b *= b;
            a *= a;
            double dr = r - 0.390625;
            double dg = g - 0.66015625;
            double db = b - 1.0;
            double da = a - 0.5625;
            double dt = Math.abs(dr) + Math.abs(dg) + Math.abs(db) + Math.abs(da);
            if (dt < allowedChange) {
                vol.setRgba(0.625f, 0.8125f, 1.0f, 0.75f);
                return;
            }
            double part = allowedChange / dt;
            vol.setRgba((float)Math.sqrt(r - (dr *= part)), (float)Math.sqrt(g - (dg *= part)), (float)Math.sqrt(b - (db *= part)), (float)Math.sqrt(a - (da *= part)));
        }
    }
}

