/*
 * Decompiled with CFR 0.152.
 */
package alexiil.mc.mod.pipes.part;

import alexiil.mc.lib.attributes.item.ItemStackCollections;
import alexiil.mc.lib.multipart.api.PartDefinition;
import alexiil.mc.mod.pipes.SimplePipes;
import alexiil.mc.mod.pipes.items.ItemFacade;
import alexiil.mc.mod.pipes.items.SimplePipeItems;
import alexiil.mc.mod.pipes.mixin.api.FindMatchingRecipesEvent;
import alexiil.mc.mod.pipes.mixin.api.RecipeMatchFinder;
import alexiil.mc.mod.pipes.part.FacadeBlockStateInfo;
import alexiil.mc.mod.pipes.part.FacadeCraftingRecipe;
import alexiil.mc.mod.pipes.part.FacadePart;
import alexiil.mc.mod.pipes.part.FacadeShape;
import alexiil.mc.mod.pipes.part.FacadeSize;
import alexiil.mc.mod.pipes.part.FacadeStateManager;
import alexiil.mc.mod.pipes.part.FullFacade;
import alexiil.mc.mod.pipes.part.PartTank;
import alexiil.mc.mod.pipes.part.PipeSpBehaviourDiamond;
import alexiil.mc.mod.pipes.part.PipeSpBehaviourIron;
import alexiil.mc.mod.pipes.pipe.PartSpPipe;
import alexiil.mc.mod.pipes.pipe.PipeSpBehaviour;
import alexiil.mc.mod.pipes.pipe.PipeSpBehaviourSided;
import alexiil.mc.mod.pipes.pipe.PipeSpBehaviourSponge;
import alexiil.mc.mod.pipes.pipe.PipeSpBehaviourWood;
import alexiil.mc.mod.pipes.pipe.PipeSpDef;
import alexiil.mc.mod.pipes.pipe.PipeSpFlowItem;
import alexiil.mc.mod.pipes.pipe.TravellingItem;
import alexiil.mc.mod.pipes.util.EnumCuboidCorner;
import alexiil.mc.mod.pipes.util.EnumCuboidEdge;
import alexiil.mc.mod.pipes.util.IngredientHelper;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1856;
import net.minecraft.class_1860;
import net.minecraft.class_1935;
import net.minecraft.class_2350;
import net.minecraft.class_2378;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_3956;
import net.minecraft.class_3975;
import net.minecraft.class_7923;
import net.minecraft.class_8786;

public final class SimplePipeParts {
    public static final PartDefinition FACADE = SimplePipeParts.def("facade", FacadePart::new, FacadePart::new);
    public static final PartDefinition TANK = SimplePipeParts.def("tank", PartTank::new, PartTank::new);
    public static final PipeSpDef.PipeDefItem WOODEN_PIPE_ITEMS = new PipeSpDef.PipeDefItem(SimplePipeParts.id("wooden_pipe_items"), true, false, 2.0){

        @Override
        public PipeSpBehaviour createBehaviour(PartSpPipe pipe) {
            return new PipeSpBehaviourWood(pipe);
        }
    };
    public static final PipeSpDef.PipeDefItem STONE_PIPE_ITEMS = new PipeSpDef.PipeDefItem(SimplePipeParts.id("stone_pipe_items"), false, false, 1.0);
    public static final PipeSpDef.PipeDefItem CLAY_PIPE_ITEMS = new PipeSpDef.PipeDefItem(SimplePipeParts.id("clay_pipe_items"), false, false, 1.0);
    public static final PipeSpDef.PipeDefItem IRON_PIPE_ITEMS = new PipeSpDef.PipeDefItem(SimplePipeParts.id("iron_pipe_items"), false, true, 1.0){

        @Override
        public PipeSpBehaviour createBehaviour(PartSpPipe pipe) {
            return new PipeSpBehaviourIron(pipe);
        }

        @Override
        public PipeSpFlowItem createFlow(final PartSpPipe part) {
            return new PipeSpFlowItem(this, part){

                @Override
                protected List<EnumSet<class_2350>> getOrderForItem(TravellingItem item, EnumSet<class_2350> validDirections) {
                    List<EnumSet<class_2350>> order = super.getOrderForItem(item, validDirections);
                    class_2350 currentDirection = ((PipeSpBehaviourSided)part.behaviour).currentDirection();
                    Iterator<EnumSet<class_2350>> iterator = order.iterator();
                    while (iterator.hasNext()) {
                        EnumSet<class_2350> set = iterator.next();
                        if (set.contains(currentDirection)) {
                            set.clear();
                            set.add(currentDirection);
                            continue;
                        }
                        iterator.remove();
                    }
                    return order;
                }
            };
        }
    };
    public static final PipeSpDef.PipeDefItem GOLD_PIPE_ITEMS = new PipeSpDef.PipeDefItem(SimplePipeParts.id("gold_pipe_items"), false, false, 6.0);
    public static final PipeSpDef.PipeDefItem DIAMOND_PIPE_ITEMS = new PipeSpDef.PipeDefItem(SimplePipeParts.id("diamond_pipe_items"), false, true, 1.0){

        @Override
        public PipeSpFlowItem createFlow(final PartSpPipe part) {
            return new PipeSpFlowItem(this, part){

                @Override
                protected List<EnumSet<class_2350>> getOrderForItem(TravellingItem item, EnumSet<class_2350> validDirections) {
                    return ((PipeSpBehaviourDiamond)part.behaviour).getOrderForItem(item, validDirections);
                }
            };
        }

        @Override
        public PipeSpBehaviour createBehaviour(PartSpPipe pipe) {
            return new PipeSpBehaviourDiamond(pipe);
        }
    };
    public static final PipeSpDef.PipeDefFluid WOODEN_PIPE_FLUIDS = new PipeSpDef.PipeDefFluid(SimplePipeParts.id("wooden_pipe_fluids"), true){

        @Override
        public PipeSpBehaviour createBehaviour(PartSpPipe pipe) {
            return new PipeSpBehaviourWood(pipe);
        }
    };
    public static final PipeSpDef.PipeDefFluid STONE_PIPE_FLUIDS = new PipeSpDef.PipeDefFluid(SimplePipeParts.id("stone_pipe_fluids"), false);
    public static final PipeSpDef.PipeDefFluid CLAY_PIPE_FLUIDS = new PipeSpDef.PipeDefFluid(SimplePipeParts.id("clay_pipe_fluids"), false);
    public static final PipeSpDef.PipeDefFluid IRON_PIPE_FLUIDS = new PipeSpDef.PipeDefFluid(SimplePipeParts.id("iron_pipe_fluids"), false){

        @Override
        public PipeSpBehaviour createBehaviour(PartSpPipe pipe) {
            return new PipeSpBehaviourIron(pipe);
        }
    };
    public static final PipeSpDef.PipeDefFluid SPONGE_PIPE_FLUIDS = new PipeSpDef.PipeDefFluid(SimplePipeParts.id("sponge_pipe_fluids"), false){

        @Override
        public PipeSpBehaviour createBehaviour(PartSpPipe pipe) {
            return new PipeSpBehaviourSponge(pipe);
        }
    };

    private SimplePipeParts() {
    }

    private static class_2960 id(String path) {
        return SimplePipes.id(path);
    }

    private static PartDefinition def(String path, PartDefinition.IPartNbtReader reader, PartDefinition.IPartNetLoader loader) {
        return new PartDefinition(SimplePipeParts.id(path), reader, loader);
    }

    public static void load() {
        FACADE.register();
        TANK.register();
        WOODEN_PIPE_ITEMS.register();
        STONE_PIPE_ITEMS.register();
        CLAY_PIPE_ITEMS.register();
        IRON_PIPE_ITEMS.register();
        GOLD_PIPE_ITEMS.register();
        DIAMOND_PIPE_ITEMS.register();
        WOODEN_PIPE_FLUIDS.register();
        STONE_PIPE_FLUIDS.register();
        CLAY_PIPE_FLUIDS.register();
        IRON_PIPE_FLUIDS.register();
        SPONGE_PIPE_FLUIDS.register();
        FindMatchingRecipesEvent.EVENT.register(SimplePipeParts::addFacadeRecipes);
        class_2378.method_10230((class_2378)class_7923.field_41189, (class_2960)FacadeCraftingRecipe.ID, (Object)((Object)FacadeCraftingRecipe.INSTANCE));
        class_2378.method_10230((class_2378)class_7923.field_49658, (class_2960)FullFacade.TYPE_ID, FullFacade.TYPE);
    }

    private static void addFacadeRecipes(RecipeMatchFinder context) {
        if (context.recipeType == class_3956.field_17641) {
            FacadeStateManager facades = FacadeStateManager.getInstance();
            Set seen = ItemStackCollections.set();
            for (int i = 0; i < context.inventory.method_59983(); ++i) {
                class_1799 stack = context.inventory.method_59984(i);
                if (stack.method_7960()) continue;
                stack = stack.method_7972();
                stack.method_7939(1);
                if (!seen.add(stack)) continue;
                if (stack.method_7909() instanceof ItemFacade) {
                    SimplePipeParts.generateFacadeToFacadeCuttingRecipes(context, stack);
                    continue;
                }
                List<FacadeBlockStateInfo> states = FacadeStateManager.getStackFacades().get(stack);
                if (states == null) continue;
                for (FacadeBlockStateInfo state : states) {
                    if (!SimplePipeParts.canCut(context, state.state)) continue;
                    SimplePipeParts.generateBlockToFacadeCuttingRecipes(context.consumer, facades, stack, state);
                }
            }
        }
    }

    private static void generateBlockToFacadeCuttingRecipes(Consumer<class_8786<class_1860<?>>> recipeAdder, FacadeStateManager facades, class_1799 stack, FacadeBlockStateInfo state) {
        class_2960 id = class_2960.method_60654((String)"buildcraftsilicon:facade_generated");
        class_1856 ingredient = SimplePipeParts.createIngredient(stack);
        for (FacadeSize size : FacadeSize.values()) {
            for (boolean hollow : new boolean[]{false, true}) {
                FacadeShape.Sided shape = FacadeShape.Sided.get(size, class_2350.field_11039, hollow);
                class_1799 output = SimplePipeItems.FACADE.createItemStack(new FullFacade(state, shape));
                output.method_7939(16 / size.microVoxelSize);
                recipeAdder.accept(new class_8786(id, (class_1860)new class_3975("", ingredient, output)));
            }
        }
        int[] stripAmounts = new int[]{4, 16, 64};
        for (int i = 0; i < FacadeSize.values().length; ++i) {
            FacadeSize size = FacadeSize.values()[i];
            FacadeShape.Strip shape = FacadeShape.Strip.get(size, EnumCuboidEdge.Z_NN);
            class_1799 output = SimplePipeItems.FACADE.createItemStack(new FullFacade(state, shape));
            output.method_7939(stripAmounts[i]);
            recipeAdder.accept(new class_8786(id, (class_1860)new class_3975("", ingredient, output)));
        }
        FacadeShape.Corner shape = FacadeShape.Corner.get(FacadeSize.SLAB, EnumCuboidCorner.NNN);
        class_1799 output = SimplePipeItems.FACADE.createItemStack(new FullFacade(state, shape));
        output.method_7939(8);
        recipeAdder.accept(new class_8786(id, (class_1860)new class_3975("", ingredient, output)));
        shape = FacadeShape.Corner.get(FacadeSize.THICK, EnumCuboidCorner.NNN);
        output = SimplePipeItems.FACADE.createItemStack(new FullFacade(state, shape));
        output.method_7939(64);
        recipeAdder.accept(new class_8786(id, (class_1860)new class_3975("", ingredient, output)));
    }

    private static void generateFacadeToFacadeCuttingRecipes(RecipeMatchFinder context, class_1799 stack) {
        ItemFacade facadeItem = (ItemFacade)stack.method_7909();
        FullFacade facade = ItemFacade.getStates(stack);
        if (facade == null) {
            return;
        }
        FacadeBlockStateInfo state = facade.state;
        if (!SimplePipeParts.canCut(context, state.state)) {
            return;
        }
        class_2960 id = class_2960.method_60654((String)"buildcraftsilicon:facade_generated");
        class_1856 ingredient = SimplePipeParts.createIngredient(stack);
        FacadeShape shape = facade.shape;
        int from = shape.getRecipeMicroVoxelVolume();
        for (FacadeShape oShape : FacadeShape.getAllItemShapes()) {
            int ratio;
            int to;
            if (shape == oShape || from < (to = oShape.recipeMicroVoxelVolume) || (ratio = from / to) > 64) continue;
            FullFacade newFacade = new FullFacade(state, oShape);
            class_1799 output = facadeItem.createItemStack(newFacade);
            output.method_7939(ratio);
            context.consumer.accept(new class_8786(id, (class_1860)new class_3975("", ingredient, output)));
        }
    }

    private static boolean canCut(RecipeMatchFinder context, class_2680 state) {
        return !state.method_29291() || new class_1799((class_1935)class_1802.field_8387).method_7951(state);
    }

    private static class_1856 createIngredient(class_1799 stack) {
        return IngredientHelper.fromStacks(stack);
    }
}

