/*
 * Decompiled with CFR 0.152.
 */
package alexiil.mc.mod.pipes.part;

import alexiil.mc.lib.net.NetByteBuf;
import alexiil.mc.mod.pipes.part.FacadeSize;
import alexiil.mc.mod.pipes.util.EnumCuboidCorner;
import alexiil.mc.mod.pipes.util.EnumCuboidEdge;
import alexiil.mc.mod.pipes.util.ShapeUtil;
import alexiil.mc.mod.pipes.util.TagUtil;
import alexiil.mc.mod.pipes.util.VecUtil;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Arrays;
import java.util.Locale;
import net.minecraft.class_2350;
import net.minecraft.class_238;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_247;
import net.minecraft.class_2487;
import net.minecraft.class_259;
import net.minecraft.class_265;
import net.minecraft.class_3532;
import net.minecraft.class_3542;
import net.minecraft.class_4990;

public abstract sealed class FacadeShape {
    private static final String NBT_KEY_CORNER = "corner";
    private static final String NBT_KEY_EDGE = "edge";
    private static final String NBT_KEY_SIDE = "side";
    private static final String NBT_TYPE_SIDED = "Sided";
    private static final String NBT_TYPE_STRIP = "Strip";
    private static final String NBT_TYPE_CORNER = "Corner";
    private static final int SHAPE_COUNT = 96;
    private static final FacadeShape[] ALL_SHAPES = new FacadeShape[96];
    private static final FacadeShape[] ITEM_SHAPES;
    private static final int VALUES_BIT_COUNT;
    public static final Codec<FacadeShape> CODEC;
    public static final Codec<FacadeShape> ITEM_CODEC;
    public final int shapeOrdinal;
    public final class_265 shape;
    public final class_243 centerOfMass;
    public final int recipeMicroVoxelVolume;

    private FacadeShape(int shapeOrdinal, class_265 shape, class_243 centerOfMass, int recipeMicroVoxelVolume) {
        this.shapeOrdinal = shapeOrdinal;
        this.shape = shape;
        this.centerOfMass = centerOfMass;
        this.recipeMicroVoxelVolume = recipeMicroVoxelVolume;
        FacadeShape.ALL_SHAPES[shapeOrdinal] = this;
    }

    private FacadeShape(int shapeOrdinal, class_265 shape, int recipeMicroVoxelVolume) {
        this(shapeOrdinal, shape, shape.method_1107().method_1005(), recipeMicroVoxelVolume);
    }

    public static FacadeShape[] getAllShapes() {
        return Arrays.copyOf(ALL_SHAPES, ALL_SHAPES.length);
    }

    public static FacadeShape[] getAllItemShapes() {
        return Arrays.copyOf(ITEM_SHAPES, ITEM_SHAPES.length);
    }

    public abstract class_2487 toTag();

    public static FacadeShape fromTag(class_2487 tag) {
        String type = tag.method_10558("type").toLowerCase(Locale.ROOT);
        FacadeSize size = TagUtil.readEnum(tag.method_10580("size"), FacadeSize.class, FacadeSize.SLAB);
        if (type.startsWith("str")) {
            return Strip.get(size, TagUtil.readEnum(tag.method_10580(NBT_KEY_EDGE), EnumCuboidEdge.class, EnumCuboidEdge.X_NN));
        }
        if (type.startsWith("c")) {
            return Corner.get(size, TagUtil.readEnum(tag.method_10580(NBT_KEY_CORNER), EnumCuboidCorner.class, EnumCuboidCorner.NNN));
        }
        return Sided.get(size, TagUtil.readEnum(tag.method_10580(NBT_KEY_SIDE), class_2350.class, class_2350.field_11036), tag.method_10577("hollow"));
    }

    public final void toBuffer(NetByteBuf buffer) {
        buffer.writeFixedBits(this.shapeOrdinal, VALUES_BIT_COUNT);
    }

    public static FacadeShape fromBuffer(NetByteBuf buffer) {
        return ALL_SHAPES[buffer.readFixedBits(VALUES_BIT_COUNT)];
    }

    public final boolean equals(Object obj) {
        return this == obj;
    }

    public final int hashCode() {
        return System.identityHashCode(this);
    }

    public abstract FacadeShape[] getPlacementVariants();

    public abstract FacadeSize getSize();

    public abstract FacadeShape transform(class_4990 var1);

    public abstract Type getType();

    public class_265 getVoxelShape() {
        return this.shape;
    }

    public class_243 getCenter() {
        return this.centerOfMass;
    }

    public int getRecipeMicroVoxelVolume() {
        return this.recipeMicroVoxelVolume;
    }

    static {
        VALUES_BIT_COUNT = class_3532.method_15342((int)96);
        ITEM_SHAPES = new FacadeShape[12];
        CODEC = Type.CODEC.dispatch("type", FacadeShape::getType, Type::getNbtCodec);
        ITEM_CODEC = Type.CODEC.dispatch("type", FacadeShape::getType, Type::getItemCodec);
    }

    public static final class Strip
    extends FacadeShape {
        private static final int CUBOID_EDGES = EnumCuboidEdge.values().length;
        public static final MapCodec<Strip> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)FacadeSize.CODEC.fieldOf("size").forGetter(Strip::getSize), (App)EnumCuboidEdge.CODEC.fieldOf(FacadeShape.NBT_KEY_EDGE).forGetter(Strip::getEdge)).apply((Applicative)instance, Strip::get));
        public static final MapCodec<Strip> ITEM_CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)FacadeSize.CODEC.fieldOf("size").forGetter(Strip::getSize)).apply((Applicative)instance, size -> Strip.get(size, EnumCuboidEdge.Z_NN)));
        private static final Strip[] values = new Strip[3 * CUBOID_EDGES];
        public final int stripOrdinal;
        public final FacadeSize size;
        public final EnumCuboidEdge edge;
        private final Strip[] placementVariants;

        private Strip(int ordinal, FacadeSize size, EnumCuboidEdge edge, Strip[] placementVariants) {
            super(Sided.values.length + ordinal, Strip.makeShape(size, edge), 16 * size.microVoxelSize * size.microVoxelSize);
            this.stripOrdinal = ordinal;
            this.size = size;
            this.edge = edge;
            this.placementVariants = placementVariants;
        }

        private static class_265 makeShape(FacadeSize size, EnumCuboidEdge edge) {
            class_243 min = class_243.field_1353;
            class_243 max = VecUtil.replaceValue(class_243.field_1353, edge.axis, 1.0);
            double offset = (double)size.microVoxelSize / 16.0;
            class_2350.class_2351 axisA = edge.touchingSide1.method_10166();
            boolean positiveA = edge.touchingSide1.method_10171() == class_2350.class_2352.field_11056;
            min = VecUtil.replaceValue(min, axisA, positiveA ? 1.0 - offset : 0.0);
            max = VecUtil.replaceValue(max, axisA, positiveA ? 1.0 : offset);
            class_2350.class_2351 axisB = edge.touchingSide2.method_10166();
            boolean positiveB = edge.touchingSide2.method_10171() == class_2350.class_2352.field_11056;
            min = VecUtil.replaceValue(min, axisB, positiveB ? 1.0 - offset : 0.0);
            max = VecUtil.replaceValue(max, axisB, positiveB ? 1.0 : offset);
            return class_259.method_1078((class_238)new class_238(min, max));
        }

        public static Strip get(FacadeSize size, EnumCuboidEdge edge) {
            return values[size.ordinal() * CUBOID_EDGES + edge.ordinal()];
        }

        public static Strip[] values() {
            return Arrays.copyOf(values, values.length);
        }

        @Override
        public class_2487 toTag() {
            class_2487 tag = new class_2487();
            tag.method_10582("type", FacadeShape.NBT_TYPE_STRIP);
            tag.method_10566(FacadeShape.NBT_KEY_EDGE, TagUtil.writeEnum(this.edge));
            tag.method_10566("size", TagUtil.writeEnum(this.size));
            return tag;
        }

        @Override
        public FacadeSize getSize() {
            return this.size;
        }

        public EnumCuboidEdge getEdge() {
            return this.edge;
        }

        @Override
        public FacadeShape transform(class_4990 transformation) {
            return Strip.get(this.size, this.edge.transform(transformation));
        }

        @Override
        public Type getType() {
            return Type.STRIP;
        }

        public Strip withSize(FacadeSize newSize) {
            return Strip.get(newSize, this.edge);
        }

        public Strip withEdge(EnumCuboidEdge newEdge) {
            return Strip.get(this.size, newEdge);
        }

        public Strip[] getPlacementVariants() {
            return Arrays.copyOf(this.placementVariants, this.placementVariants.length);
        }

        static {
            int index = 0;
            for (FacadeSize size : FacadeSize.values()) {
                Strip[] variants = new Strip[12];
                for (EnumCuboidEdge edge : EnumCuboidEdge.values()) {
                    Strip strip;
                    variants[edge.ordinal()] = Strip.values[index] = (strip = new Strip(index, size, edge, variants));
                    ++index;
                }
            }
            FacadeShape.ITEM_SHAPES[6] = Strip.get(FacadeSize.SLAB, EnumCuboidEdge.Z_NN);
            FacadeShape.ITEM_SHAPES[7] = Strip.get(FacadeSize.THICK, EnumCuboidEdge.Z_NN);
            FacadeShape.ITEM_SHAPES[8] = Strip.get(FacadeSize.THIN, EnumCuboidEdge.Z_NN);
        }
    }

    public static final class Corner
    extends FacadeShape {
        private static final int CUBOID_CORNERS = EnumCuboidCorner.values().length;
        public static final MapCodec<Corner> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)FacadeSize.CODEC.fieldOf("size").forGetter(Corner::getSize), (App)EnumCuboidCorner.CODEC.fieldOf(FacadeShape.NBT_KEY_CORNER).forGetter(Corner::getCorner)).apply((Applicative)instance, Corner::get));
        public static final MapCodec<Corner> ITEM_CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)FacadeSize.CODEC.fieldOf("size").forGetter(Corner::getSize)).apply((Applicative)instance, size -> Corner.get(size, EnumCuboidCorner.NNN)));
        private static final Corner[] values = new Corner[3 * CUBOID_CORNERS];
        public final int cornerOrdinal;
        public final FacadeSize size;
        public final EnumCuboidCorner corner;
        private final Corner[] placementVariants;

        private Corner(int ordinal, FacadeSize size, EnumCuboidCorner corner, Corner[] placementVariants) {
            super(Sided.values.length + Strip.values.length + ordinal, Corner.makeShape(size, corner), Corner.makeCentreOfMass(size, corner), size.voxelVolume());
            this.cornerOrdinal = ordinal;
            this.size = size;
            this.corner = corner;
            this.placementVariants = placementVariants;
        }

        private static class_265 makeShape(FacadeSize size, EnumCuboidCorner corner) {
            boolean x = corner.x == class_2350.class_2352.field_11056;
            boolean y = corner.y == class_2350.class_2352.field_11056;
            boolean z = corner.z == class_2350.class_2352.field_11056;
            int x0 = x ? 16 - size.microVoxelSize : 0;
            int y0 = y ? 16 - size.microVoxelSize : 0;
            int z0 = z ? 16 - size.microVoxelSize : 0;
            int x1 = x ? 16 : size.microVoxelSize;
            int y1 = y ? 16 : size.microVoxelSize;
            int z1 = z ? 16 : size.microVoxelSize;
            return ShapeUtil.cuboid16(x0, y0, z0, x1, y1, z1);
        }

        private static class_243 makeCentreOfMass(FacadeSize size, EnumCuboidCorner corner) {
            boolean x = corner.x == class_2350.class_2352.field_11056;
            boolean y = corner.y == class_2350.class_2352.field_11056;
            boolean z = corner.z == class_2350.class_2352.field_11056;
            double low = (double)size.microVoxelSize / 32.0;
            double high = 1.0 - low;
            return new class_243(x ? high : low, y ? high : low, z ? high : low);
        }

        public static Corner get(FacadeSize size, EnumCuboidCorner corner) {
            return values[size.ordinal() * CUBOID_CORNERS + corner.ordinal()];
        }

        public static Corner[] values() {
            return Arrays.copyOf(values, values.length);
        }

        @Override
        public class_2487 toTag() {
            class_2487 tag = new class_2487();
            tag.method_10582("type", FacadeShape.NBT_TYPE_CORNER);
            tag.method_10566(FacadeShape.NBT_KEY_CORNER, TagUtil.writeEnum(this.corner));
            tag.method_10566("size", TagUtil.writeEnum(this.size));
            return tag;
        }

        @Override
        public FacadeSize getSize() {
            return this.size;
        }

        public EnumCuboidCorner getCorner() {
            return this.corner;
        }

        @Override
        public FacadeShape transform(class_4990 transformation) {
            return Corner.get(this.size, this.corner.transform(transformation));
        }

        @Override
        public Type getType() {
            return Type.CORNER;
        }

        public Corner withSize(FacadeSize newSize) {
            return Corner.get(newSize, this.corner);
        }

        public Corner withCorner(EnumCuboidCorner newCorner) {
            return Corner.get(this.size, newCorner);
        }

        public Corner[] getPlacementVariants() {
            return Arrays.copyOf(this.placementVariants, this.placementVariants.length);
        }

        static {
            int index = 0;
            for (FacadeSize size : FacadeSize.values()) {
                Corner[] variants = new Corner[8];
                for (EnumCuboidCorner corner : EnumCuboidCorner.values()) {
                    variants[corner.ordinal()] = Corner.values[index] = new Corner(index, size, corner, variants);
                    ++index;
                }
            }
            FacadeShape.ITEM_SHAPES[9] = Corner.get(FacadeSize.SLAB, EnumCuboidCorner.NNN);
            FacadeShape.ITEM_SHAPES[10] = Corner.get(FacadeSize.THICK, EnumCuboidCorner.NNN);
            FacadeShape.ITEM_SHAPES[11] = Corner.get(FacadeSize.THIN, EnumCuboidCorner.NNN);
        }
    }

    public static final class Sided
    extends FacadeShape {
        public static final MapCodec<Sided> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)FacadeSize.CODEC.fieldOf("size").forGetter(Sided::getSize), (App)class_2350.field_29502.fieldOf(FacadeShape.NBT_KEY_SIDE).forGetter(Sided::getSide), (App)Codec.BOOL.fieldOf("hollow").forGetter(Sided::isHollow)).apply((Applicative)instance, Sided::get));
        public static final MapCodec<Sided> ITEM_CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)FacadeSize.CODEC.fieldOf("size").forGetter(Sided::getSize), (App)Codec.BOOL.fieldOf("hollow").forGetter(Sided::isHollow)).apply((Applicative)instance, (size, hollow) -> Sided.get(size, class_2350.field_11039, hollow)));
        private static final Sided[] values = new Sided[36];
        public final int sidedOrdinal;
        public final class_2350 side;
        public final boolean hollow;
        public final FacadeSize size;
        private final Sided[] placementVariants;

        private Sided(int ordinal, class_2350 side, boolean hollow, FacadeSize size, Sided[] placementVariants) {
            super(ordinal, Sided.makeShape(side, hollow, size), Sided.makeCentreOfMass(side, size), 256 * size.microVoxelSize);
            this.sidedOrdinal = ordinal;
            this.side = side;
            this.hollow = hollow;
            this.size = size;
            this.placementVariants = placementVariants;
        }

        private static class_265 makeShape(class_2350 side, boolean hollow, FacadeSize size) {
            class_265 shape = ShapeUtil.cuboid16(0, 0, 0, 16, size.microVoxelSize, 16);
            if (hollow) {
                shape = class_259.method_1082((class_265)shape, (class_265)ShapeUtil.cuboid16(4, 0, 4, 12, size.microVoxelSize, 12), (class_247)class_247.field_16886);
            }
            return ShapeUtil.rotate90(shape, class_2350.field_11033, side);
        }

        private static class_243 makeCentreOfMass(class_2350 side, FacadeSize size) {
            class_243 sideVec = class_243.method_24954((class_2382)side.method_10163());
            return VecUtil.VEC_HALF.method_1019(sideVec.method_1021(0.5 - (double)size.microVoxelSize / 32.0));
        }

        public static Sided get(FacadeSize size, class_2350 side, boolean hollow) {
            if (side == null) {
                throw new NullPointerException(FacadeShape.NBT_KEY_SIDE);
            }
            if (size == null) {
                throw new NullPointerException("size");
            }
            return values[(switch (size) {
                case FacadeSize.SLAB -> 0;
                case FacadeSize.THICK -> 12;
                case FacadeSize.THIN -> 24;
                default -> throw new IllegalStateException("Unknown FacadeSize " + String.valueOf((Object)size) + "!");
            }) + side.ordinal() * 2 + (hollow ? 1 : 0)];
        }

        public static Sided[] values() {
            return Arrays.copyOf(values, values.length);
        }

        @Override
        public class_2487 toTag() {
            class_2487 tag = new class_2487();
            tag.method_10582("type", FacadeShape.NBT_TYPE_SIDED);
            tag.method_10566(FacadeShape.NBT_KEY_SIDE, TagUtil.writeEnum(this.side));
            tag.method_10566("size", TagUtil.writeEnum(this.size));
            tag.method_10556("hollow", this.hollow);
            return tag;
        }

        @Override
        public FacadeSize getSize() {
            return this.size;
        }

        public class_2350 getSide() {
            return this.side;
        }

        public boolean isHollow() {
            return this.hollow;
        }

        @Override
        public FacadeShape transform(class_4990 transformation) {
            return Sided.get(this.size, transformation.method_26388(this.side), this.hollow);
        }

        @Override
        public Type getType() {
            return Type.SIDED;
        }

        public Sided withSize(FacadeSize newSize) {
            return Sided.get(newSize, this.side, this.hollow);
        }

        public Sided withSide(class_2350 newSide) {
            return Sided.get(this.size, newSide, this.hollow);
        }

        public Sided withHollow(boolean newHollow) {
            return Sided.get(this.size, this.side, newHollow);
        }

        public Sided[] getPlacementVariants() {
            return Arrays.copyOf(this.placementVariants, this.placementVariants.length);
        }

        static {
            int index = 0;
            for (FacadeSize size : FacadeSize.values()) {
                Sided[] solidVariants = new Sided[6];
                Sided[] hollowVariants = new Sided[6];
                for (class_2350 side : class_2350.values()) {
                    solidVariants[side.ordinal()] = Sided.values[index] = new Sided(index, side, false, size, solidVariants);
                    hollowVariants[side.ordinal()] = Sided.values[index] = new Sided(++index, side, true, size, hollowVariants);
                    ++index;
                }
            }
            FacadeShape.ITEM_SHAPES[0] = Sided.get(FacadeSize.SLAB, class_2350.field_11039, false);
            FacadeShape.ITEM_SHAPES[1] = Sided.get(FacadeSize.SLAB, class_2350.field_11039, true);
            FacadeShape.ITEM_SHAPES[2] = Sided.get(FacadeSize.THICK, class_2350.field_11039, false);
            FacadeShape.ITEM_SHAPES[3] = Sided.get(FacadeSize.THICK, class_2350.field_11039, true);
            FacadeShape.ITEM_SHAPES[4] = Sided.get(FacadeSize.THIN, class_2350.field_11039, false);
            FacadeShape.ITEM_SHAPES[5] = Sided.get(FacadeSize.THIN, class_2350.field_11039, true);
        }
    }

    public static enum Type implements class_3542
    {
        SIDED("Sided", Sided.CODEC, Sided.ITEM_CODEC),
        STRIP("Strip", Strip.CODEC, Strip.ITEM_CODEC),
        CORNER("Corner", Corner.CODEC, Corner.ITEM_CODEC);

        public static final Codec<Type> CODEC;
        private final String nbtName;
        private final MapCodec<? extends FacadeShape> nbtCodec;
        private final MapCodec<? extends FacadeShape> itemCodec;

        private Type(String nbtName, MapCodec<? extends FacadeShape> nbtCodec, MapCodec<? extends FacadeShape> itemCodec) {
            this.nbtName = nbtName;
            this.nbtCodec = nbtCodec;
            this.itemCodec = itemCodec;
        }

        public String method_15434() {
            return this.nbtName;
        }

        public MapCodec<? extends FacadeShape> getNbtCodec() {
            return this.nbtCodec;
        }

        public MapCodec<? extends FacadeShape> getItemCodec() {
            return this.itemCodec;
        }

        static {
            CODEC = class_3542.method_28140(Type::values);
        }
    }
}

