/*
 * Decompiled with CFR 0.152.
 */
package alexiil.mc.mod.pipes.part;

import alexiil.mc.lib.multipart.api.AbstractPart;
import alexiil.mc.lib.multipart.api.MultipartEventBus;
import alexiil.mc.lib.multipart.api.MultipartHolder;
import alexiil.mc.lib.multipart.api.PartDefinition;
import alexiil.mc.lib.multipart.api.event.PartTransformEvent;
import alexiil.mc.lib.multipart.api.render.PartModelKey;
import alexiil.mc.lib.net.IMsgReadCtx;
import alexiil.mc.lib.net.IMsgWriteCtx;
import alexiil.mc.lib.net.InvalidInputDataException;
import alexiil.mc.lib.net.NetByteBuf;
import alexiil.mc.mod.pipes.client.model.part.FacadePartKey;
import alexiil.mc.mod.pipes.items.SimplePipeItems;
import alexiil.mc.mod.pipes.part.FacadeBlockStateInfo;
import alexiil.mc.mod.pipes.part.FacadeShape;
import alexiil.mc.mod.pipes.part.FacadeSize;
import alexiil.mc.mod.pipes.part.FullFacade;
import net.minecraft.class_1799;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_259;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_7225;

public class FacadePart
extends AbstractPart {
    public final FacadeBlockStateInfo state;
    private FacadeShape shape;

    public FacadePart(PartDefinition definition, MultipartHolder holder, FacadeBlockStateInfo states, FacadeShape shape) {
        super(definition, holder);
        this.state = states;
        this.shape = shape;
    }

    public FacadePart(PartDefinition definition, MultipartHolder holder, class_2487 tag, class_7225.class_7874 lookup) {
        super(definition, holder);
        this.state = FacadeBlockStateInfo.fromTag(tag.method_10562("states"));
        this.shape = FacadeShape.fromTag(tag.method_10562("shape"));
    }

    public class_2487 toTag(class_7225.class_7874 lookup) {
        class_2487 tag = super.toTag(lookup);
        tag.method_10566("states", (class_2520)this.state.toTag());
        tag.method_10566("shape", (class_2520)this.shape.toTag());
        return tag;
    }

    public FacadePart(PartDefinition definition, MultipartHolder holder, NetByteBuf buffer, IMsgReadCtx ctx) throws InvalidInputDataException {
        super(definition, holder);
        this.state = FacadeBlockStateInfo.readFromBuffer(buffer);
        this.shape = FacadeShape.fromBuffer(buffer);
    }

    public void writeCreationData(NetByteBuf buffer, IMsgWriteCtx ctx) {
        super.writeCreationData(buffer, ctx);
        this.state.writeToBuffer(buffer);
        this.shape.toBuffer(buffer);
    }

    public void readRenderData(NetByteBuf buffer, IMsgReadCtx ctx) throws InvalidInputDataException {
        super.readRenderData(buffer, ctx);
        this.shape = FacadeShape.fromBuffer(buffer);
    }

    public void writeRenderData(NetByteBuf buffer, IMsgWriteCtx ctx) {
        super.writeRenderData(buffer, ctx);
        this.shape.toBuffer(buffer);
    }

    public void onAdded(MultipartEventBus bus) {
        super.onAdded(bus);
        bus.addListener((Object)this, PartTransformEvent.class, event -> {
            this.shape = this.shape.transform(event.transformation);
        });
    }

    public class_265 getShape() {
        return this.shape.shape;
    }

    public class_265 getCullingShape() {
        return this.state.state.method_26225() ? this.getShape() : class_259.method_1073();
    }

    public class_1799 getPickStack() {
        return SimplePipeItems.FACADE.createItemStack(new FullFacade(this.state, this.shape));
    }

    protected class_2680 getClosestBlockState() {
        return this.state.state;
    }

    public boolean canOverlapWith(AbstractPart other) {
        if (other instanceof FacadePart) {
            FacadePart o = (FacadePart)other;
            return this.shape.getSize() != FacadeSize.SLAB || o.shape.getSize() != FacadeSize.SLAB;
        }
        return false;
    }

    public PartModelKey getModelKey() {
        int insetSides;
        FacadeShape facadeShape = this.shape;
        if (facadeShape instanceof FacadeShape.Sided) {
            FacadeShape.Sided sided = (FacadeShape.Sided)facadeShape;
            insetSides = this.container.getParts(FacadePart.class, part -> part.shape instanceof FacadeShape.Sided).stream().reduce(0, (faces, part) -> {
                Integer n;
                FacadeShape patt0$temp = part.shape;
                if (patt0$temp instanceof FacadeShape.Sided) {
                    FacadeShape.Sided s = (FacadeShape.Sided)patt0$temp;
                    n = faces | 1 << s.side.method_10146();
                } else {
                    n = faces;
                }
                return n;
            }, (a, b) -> a | b) & ~(1 << sided.side.method_10146());
        } else {
            insetSides = 0;
        }
        return new FacadePartKey(this.shape, this.state.state, insetSides);
    }
}

