/*
 * Decompiled with CFR 0.152.
 */
package alexiil.mc.mod.pipes.part;

import alexiil.mc.lib.net.NetByteBuf;
import alexiil.mc.mod.pipes.part.FacadeStateManager;
import alexiil.mc.mod.pipes.util.MessageUtil;
import com.google.common.collect.ImmutableSet;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import java.util.Objects;
import java.util.Optional;
import java.util.SortedMap;
import net.minecraft.class_1799;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2487;
import net.minecraft.class_2512;
import net.minecraft.class_2540;
import net.minecraft.class_2680;
import net.minecraft.class_2688;
import net.minecraft.class_2689;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_7923;
import net.minecraft.class_9129;
import net.minecraft.class_9135;
import net.minecraft.class_9139;

public class FacadeBlockStateInfo {
    public static final Codec<FacadeBlockStateInfo> CODEC = class_2680.field_24734.comapFlatMap(state -> {
        SortedMap<class_2680, FacadeBlockStateInfo> map = FacadeStateManager.getValidFacadeStates();
        FacadeBlockStateInfo info = (FacadeBlockStateInfo)map.get(state);
        if (info == null) {
            return DataResult.error(() -> "No facade state associated with block state " + String.valueOf(state));
        }
        return DataResult.success((Object)info);
    }, info -> info.state);
    public static final class_9139<class_9129, FacadeBlockStateInfo> PACKET_CODEC = class_9135.method_56896(CODEC);
    public final class_2680 state;
    public final class_1799 requiredStack;
    public final ImmutableSet<class_2769<?>> varyingProperties;
    public final boolean isVisible;

    public FacadeBlockStateInfo(class_2680 state, class_1799 requiredStack, ImmutableSet<class_2769<?>> varyingProperties) {
        this.state = Objects.requireNonNull(state, "state must not be null!");
        Objects.requireNonNull(state.method_26204(), "state.getBlock must not be null!");
        Objects.requireNonNull(class_7923.field_41175.method_10221((Object)state.method_26204()));
        this.requiredStack = requiredStack;
        this.varyingProperties = varyingProperties;
        this.isVisible = !requiredStack.method_7960();
    }

    public String toString() {
        return "StateInfo [id=" + System.identityHashCode(this) + ", block = " + String.valueOf(this.state.method_26204()) + ", state =  " + this.state.toString() + "]";
    }

    public static FacadeBlockStateInfo fromTag(class_2487 nbt) {
        return FacadeBlockStateInfo.fromTag(nbt, FacadeStateManager.getValidFacadeStates());
    }

    public static class_2680 toBlockState(class_2487 compound) {
        if (!compound.method_10573("Name", 8)) {
            return class_2246.field_10124.method_9564();
        }
        class_2248 block = (class_2248)class_7923.field_41175.method_10223(class_2960.method_60654((String)compound.method_10558("Name")));
        class_2680 blockState = block.method_9564();
        if (compound.method_10573("Properties", 10)) {
            class_2487 nbtCompound = compound.method_10562("Properties");
            class_2689 stateManager = block.method_9595();
            for (String string : nbtCompound.method_10541()) {
                class_2769 property = stateManager.method_11663(string);
                if (property == null) continue;
                blockState = FacadeBlockStateInfo.withProperty(blockState, property, string, nbtCompound, compound);
            }
        }
        return blockState;
    }

    private static <S extends class_2688<?, S>, T extends Comparable<T>> S withProperty(S state, class_2769<T> property, String key, class_2487 properties, class_2487 root) {
        Optional optional = property.method_11900(properties.method_10558(key));
        if (optional.isPresent()) {
            return (S)((class_2688)state.method_11657(property, (Comparable)optional.get()));
        }
        System.out.printf("Unable to read property: {%s} with value: {%s} for blockstate: {%s}", key, properties.method_10558(key), root.toString());
        return state;
    }

    static FacadeBlockStateInfo fromTag(class_2487 nbt, SortedMap<class_2680, FacadeBlockStateInfo> validStates) {
        try {
            FacadeBlockStateInfo stateInfo = FacadeStateManager.getDefaultState();
            class_2680 blockState = FacadeBlockStateInfo.toBlockState(nbt);
            stateInfo = (FacadeBlockStateInfo)validStates.get(blockState);
            if (stateInfo == null) {
                stateInfo = FacadeStateManager.getDefaultState();
            }
            return stateInfo;
        }
        catch (Throwable t) {
            throw new RuntimeException("Failed badly when reading a facade state!", t);
        }
    }

    @Deprecated
    public class_2487 toTag() {
        try {
            return class_2512.method_10686((class_2680)this.state);
        }
        catch (Throwable t) {
            throw new IllegalStateException("Writing facade block state\n\tBlock = " + String.valueOf(this.state.method_26204()) + "\n\tBlock Class = " + String.valueOf(this.state.method_26204().getClass()), t);
        }
    }

    public static FacadeBlockStateInfo readFromBuffer(NetByteBuf buf) {
        return FacadeBlockStateInfo.readFromBuffer(buf, FacadeStateManager.getValidFacadeStates());
    }

    static FacadeBlockStateInfo readFromBuffer(NetByteBuf buf, SortedMap<class_2680, FacadeBlockStateInfo> validStates) {
        class_2680 state = MessageUtil.readBlockState((class_2540)buf);
        FacadeBlockStateInfo info = (FacadeBlockStateInfo)validStates.get(state);
        if (info == null) {
            info = FacadeStateManager.getDefaultState();
        }
        return info;
    }

    public void writeToBuffer(NetByteBuf buf) {
        try {
            MessageUtil.writeBlockState((class_2540)buf, this.state);
        }
        catch (Throwable t) {
            throw new IllegalStateException("Writing facade block state\n\tState = " + String.valueOf(this.state), t);
        }
    }
}

