/*
 * Decompiled with CFR 0.152.
 */
package alexiil.mc.mod.pipes.items;

import alexiil.mc.lib.multipart.api.AbstractPart;
import alexiil.mc.lib.multipart.api.MultipartContainer;
import alexiil.mc.lib.multipart.api.MultipartHolder;
import alexiil.mc.lib.multipart.api.MultipartUtil;
import alexiil.mc.mod.pipes.SimplePipes;
import alexiil.mc.mod.pipes.items.GhostPlacement;
import alexiil.mc.mod.pipes.items.GhostPlacementPart;
import alexiil.mc.mod.pipes.items.IItemPlacmentGhost;
import alexiil.mc.mod.pipes.part.FacadeBlockStateInfo;
import alexiil.mc.mod.pipes.part.FacadePart;
import alexiil.mc.mod.pipes.part.FacadeShape;
import alexiil.mc.mod.pipes.part.FacadeSize;
import alexiil.mc.mod.pipes.part.FacadeStateManager;
import alexiil.mc.mod.pipes.part.FullFacade;
import alexiil.mc.mod.pipes.part.SimplePipeParts;
import alexiil.mc.mod.pipes.util.BlockUtil;
import alexiil.mc.mod.pipes.util.EnumCuboidCorner;
import alexiil.mc.mod.pipes.util.EnumCuboidEdge;
import alexiil.mc.mod.pipes.util.SoundUtil;
import alexiil.mc.mod.pipes.util.TagUtil;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.class_124;
import net.minecraft.class_1269;
import net.minecraft.class_1761;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_1838;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_5250;
import net.minecraft.class_7923;
import net.minecraft.class_9334;

public class ItemFacade
extends class_1792
implements IItemPlacmentGhost {
    public static final FacadeShape DEFAULT_SHAPE = FacadeShape.Sided.get(FacadeSize.THIN, class_2350.field_11039, false);
    private static final FacadeShape[] PREVIEW_SHAPES = new FacadeShape[]{FacadeShape.Sided.get(FacadeSize.SLAB, class_2350.field_11039, false), FacadeShape.Sided.get(FacadeSize.SLAB, class_2350.field_11039, true), FacadeShape.Sided.get(FacadeSize.THICK, class_2350.field_11039, false), FacadeShape.Sided.get(FacadeSize.THICK, class_2350.field_11039, true), FacadeShape.Sided.get(FacadeSize.THIN, class_2350.field_11039, false), FacadeShape.Sided.get(FacadeSize.THIN, class_2350.field_11039, true), FacadeShape.Strip.get(FacadeSize.SLAB, EnumCuboidEdge.Z_NN), FacadeShape.Strip.get(FacadeSize.THICK, EnumCuboidEdge.Z_NN), FacadeShape.Strip.get(FacadeSize.THIN, EnumCuboidEdge.Z_NN), FacadeShape.Corner.get(FacadeSize.SLAB, EnumCuboidCorner.NNN), FacadeShape.Corner.get(FacadeSize.THICK, EnumCuboidCorner.NNN), FacadeShape.Corner.get(FacadeSize.THIN, EnumCuboidCorner.NNN)};

    public ItemFacade(class_1792.class_1793 settings) {
        super(settings);
    }

    @Nonnull
    public class_1799 createItemStack(FullFacade state) {
        class_1799 item = new class_1799((class_1935)this);
        item.method_57379(FullFacade.TYPE, (Object)state);
        return item;
    }

    public static FullFacade getStates(class_1799 item) {
        class_2499 states;
        FullFacade facadeComponent = (FullFacade)item.method_57824(FullFacade.TYPE);
        if (facadeComponent != null) {
            return facadeComponent;
        }
        class_2487 nbt = TagUtil.getItemData(item);
        String strPreview = nbt.method_10558("preview");
        if ("basic".equalsIgnoreCase(strPreview)) {
            return new FullFacade(FacadeStateManager.getPreviewState(), DEFAULT_SHAPE);
        }
        if (!nbt.method_10545("facade") && nbt.method_10545("states") && (states = nbt.method_10554("states", (int)new class_2487().method_10711())).size() > 0) {
            boolean isHollow = states.method_10602(0).method_10577("isHollow");
            class_2487 tagFacade = new class_2487();
            tagFacade.method_10556("isHollow", isHollow);
            tagFacade.method_10566("states", (class_2520)states);
            nbt.method_10566("facade", (class_2520)tagFacade);
        }
        FullFacade full = new FullFacade(nbt.method_10562("facade"));
        if (full.shape instanceof FacadeShape.Sided) {
            full = new FullFacade(full.state, ((FacadeShape.Sided)full.shape).withSide(class_2350.field_11039));
        }
        if (full.shape instanceof FacadeShape.Strip) {
            full = new FullFacade(full.state, ((FacadeShape.Strip)full.shape).withEdge(EnumCuboidEdge.Z_NN));
        }
        item.method_57379(FullFacade.TYPE, (Object)full);
        if (nbt.method_10546() == 1 && nbt.method_10545("facade") || nbt.method_10546() == 2 && nbt.method_10545("facade") && nbt.method_10545("states")) {
            item.method_57381(class_9334.field_49628);
        }
        return full;
    }

    @Nonnull
    public class_1799 getFacadeForBlock(class_2680 state, FacadeShape shape) {
        FacadeBlockStateInfo info = (FacadeBlockStateInfo)FacadeStateManager.getValidFacadeStates().get(state);
        if (info == null) {
            return class_1799.field_8037;
        }
        return this.createItemStack(new FullFacade(info, shape));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addSubItems(class_1761.class_7704 subItems) {
        try {
            FacadeStateManager.lock();
            int count = 0;
            FacadeBlockStateInfo stone = FacadeStateManager.getInfoForBlock(class_2246.field_10340);
            if (stone != null) {
                for (FacadeBlockStateInfo info : FacadeStateManager.getValidFacadeStates().values()) {
                    if (class_7923.field_41175.method_10137().equals((Object)class_7923.field_41175.method_10221((Object)info.state.method_26204())) || !info.isVisible) continue;
                    for (FacadeShape shape : PREVIEW_SHAPES) {
                        ++count;
                        subItems.method_45420(this.createItemStack(new FullFacade(info, shape)));
                    }
                }
            }
            if (FacadeStateManager.DEBUG) {
                SimplePipes.LOGGER.info("[facades] " + count + " sub facade items");
            }
        }
        finally {
            FacadeStateManager.unlock();
        }
    }

    public class_2561 method_7864(class_1799 stack) {
        FullFacade facade = ItemFacade.getStates(stack);
        Object key = "item.simple_pipes.plug_facade.";
        if (facade.shape instanceof FacadeShape.Sided) {
            FacadeShape.Sided sided = (FacadeShape.Sided)facade.shape;
            if (sided.isHollow()) {
                key = (String)key + "hollow.";
            }
        } else {
            key = facade.shape instanceof FacadeShape.Strip ? (String)key + "strip." : (facade.shape instanceof FacadeShape.Corner ? (String)key + "corner." : (String)key + "unknown_shape");
        }
        key = (String)key + facade.shape.getSize().name().toLowerCase(Locale.ROOT);
        return class_2561.method_43469((String)key, (Object[])new Object[]{ItemFacade.getFacadeStateDisplayName(facade.state.state)});
    }

    public static class_5250 getFacadeStateDisplayName(class_2680 state) {
        return class_2561.method_43471((String)state.method_26204().method_9539());
    }

    public void method_7851(class_1799 stack, class_1792.class_9635 context, List<class_2561> tooltip, class_1836 type) {
        FullFacade states = ItemFacade.getStates(stack);
        if (type.method_8035()) {
            class_2960 blockId = class_7923.field_41175.method_10221((Object)states.state.state.method_26204());
            tooltip.add(class_2561.method_30163((String)blockId.toString()));
        }
        String propertiesStart = String.valueOf(class_124.field_1080) + String.valueOf(class_124.field_1056);
        FacadeBlockStateInfo info = states.state;
        BlockUtil.getPropertiesStringMap(info.state, info.varyingProperties).forEach((name, value) -> tooltip.add(class_2561.method_30163((String)(propertiesStart + name + " = " + value))));
    }

    @Nullable
    private static MultipartContainer.PartOffer offer(class_1838 ctx) {
        class_1937 w = ctx.method_8045();
        FullFacade fullState = ItemFacade.getStates(ctx.method_8041());
        ArrayList<FacadePotentialPlacament> variants = new ArrayList<FacadePotentialPlacament>();
        FacadeShape[] shapeVariants = fullState.shape.getPlacementVariants();
        for (class_2338 pos : class_2338.method_10097((class_2338)ctx.method_8037().method_10069(-1, -1, -1), (class_2338)ctx.method_8037().method_10069(1, 1, 1))) {
            for (FacadeShape shape : shapeVariants) {
                variants.add(new FacadePotentialPlacament(shape, pos.method_10062()));
            }
        }
        class_243 hit = ctx.method_17698();
        variants.sort(Comparator.comparingDouble(potential -> potential.centre.method_1022(hit)));
        for (FacadePotentialPlacament variant : variants) {
            MultipartContainer.PartOffer offer = MultipartUtil.offerNewPart((class_1937)w, (class_2338)variant.pos, h -> ItemFacade.createFacade(fullState.state, variant.shape, h));
            if (offer == null) continue;
            return offer;
        }
        return null;
    }

    public class_1269 method_7884(class_1838 ctx) {
        class_1937 w = ctx.method_8045();
        if (w.field_9236) {
            return class_1269.field_5812;
        }
        MultipartContainer.PartOffer offer = ItemFacade.offer(ctx);
        if (offer != null) {
            FullFacade fullState = ItemFacade.getStates(ctx.method_8041());
            offer.apply();
            ctx.method_8041().method_7933(-1);
            SoundUtil.playBlockPlace(ctx.method_8045(), ctx.method_8037(), fullState.state.state);
            return class_1269.field_21466;
        }
        return class_1269.field_5814;
    }

    private static AbstractPart createFacade(FacadeBlockStateInfo states, FacadeShape shape, MultipartHolder h) {
        return new FacadePart(SimplePipeParts.FACADE, h, states, shape);
    }

    @Override
    public GhostPlacement createGhostPlacement(class_1838 ctx) {
        return new FacadePlacement();
    }

    static final class FacadePotentialPlacament {
        public final FacadeShape shape;
        public final class_2338 pos;
        public final class_243 centre;

        FacadePotentialPlacament(FacadeShape shape, class_2338 pos) {
            this.shape = shape;
            this.pos = pos;
            this.centre = class_243.method_24954((class_2382)pos).method_1019(shape.centerOfMass);
        }
    }

    class FacadePlacement
    extends GhostPlacementPart {
        FacadePlacement() {
        }

        @Override
        public GhostPlacement preRender(class_1838 ctx) {
            if (ctx.method_8041().method_7909() != ItemFacade.this) {
                return null;
            }
            return this.setup(ItemFacade.offer(ctx)) ? this : null;
        }
    }
}

