/*
 * Decompiled with CFR 0.152.
 */
package alexiil.mc.mod.pipes.client.model;

import alexiil.mc.mod.pipes.client.model.MutableQuad;
import alexiil.mc.mod.pipes.mixin.impl.BufferBuilderAccessor;
import alexiil.mc.mod.pipes.util.SpriteUtil;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.renderer.v1.mesh.QuadEmitter;
import net.minecraft.class_1058;
import net.minecraft.class_2382;
import net.minecraft.class_241;
import net.minecraft.class_243;
import net.minecraft.class_287;
import net.minecraft.class_290;
import net.minecraft.class_293;
import net.minecraft.class_296;
import net.minecraft.class_3532;
import org.joml.Vector3f;
import org.joml.Vector4f;

@Environment(value=EnvType.CLIENT)
public class MutableVertex {
    public float position_x;
    public float position_y;
    public float position_z;
    public float normal_x;
    public float normal_y;
    public float normal_z;
    public short colour_r;
    public short colour_g;
    public short colour_b;
    public short colour_a;
    public float tex_u;
    public float tex_v;
    public byte light_block;
    public byte light_sky;

    public MutableVertex() {
        this.normal_x = 0.0f;
        this.normal_y = 1.0f;
        this.normal_z = 0.0f;
        this.colour_r = (short)255;
        this.colour_g = (short)255;
        this.colour_b = (short)255;
        this.colour_a = (short)255;
    }

    public MutableVertex(MutableVertex from) {
        this.copyFrom(from);
    }

    public MutableVertex(MutableVertex a, MutableVertex b, float interp) {
        this.position_x = class_3532.method_16439((float)a.position_x, (float)b.position_x, (float)interp);
        this.position_y = class_3532.method_16439((float)a.position_y, (float)b.position_y, (float)interp);
        this.position_z = class_3532.method_16439((float)a.position_z, (float)b.position_z, (float)interp);
        this.normal_x = class_3532.method_16439((float)a.normal_x, (float)b.normal_x, (float)interp);
        this.normal_y = class_3532.method_16439((float)a.normal_y, (float)b.normal_y, (float)interp);
        this.normal_z = class_3532.method_16439((float)a.normal_z, (float)b.normal_z, (float)interp);
        this.colour_r = (short)class_3532.method_16439((float)a.colour_r, (float)b.colour_r, (float)interp);
        this.colour_g = (short)class_3532.method_16439((float)a.colour_g, (float)b.colour_g, (float)interp);
        this.colour_b = (short)class_3532.method_16439((float)a.colour_b, (float)b.colour_b, (float)interp);
        this.colour_a = (short)class_3532.method_16439((float)a.colour_a, (float)b.colour_a, (float)interp);
        this.tex_u = class_3532.method_16439((float)a.tex_u, (float)b.tex_u, (float)interp);
        this.tex_v = class_3532.method_16439((float)a.tex_v, (float)b.tex_v, (float)interp);
        this.light_block = (byte)class_3532.method_16439((float)a.light_block, (float)b.light_block, (float)interp);
        this.light_sky = (byte)class_3532.method_16439((float)a.light_sky, (float)b.light_sky, (float)interp);
    }

    public String toString() {
        return "{ pos = [ " + this.position_x + ", " + this.position_y + ", " + this.position_z + " ], norm = [ " + this.normal_x + ", " + this.normal_y + ", " + this.normal_z + " ], colour = [ " + this.colour_r + ", " + this.colour_g + ", " + this.colour_b + ", " + this.colour_a + " ], tex = [ " + this.tex_u + ", " + this.tex_v + " ], light_block = " + this.light_block + ", light_sky = " + this.light_sky + " }";
    }

    public MutableVertex copyFrom(MutableVertex from) {
        this.position_x = from.position_x;
        this.position_y = from.position_y;
        this.position_z = from.position_z;
        this.normal_x = from.normal_x;
        this.normal_y = from.normal_y;
        this.normal_z = from.normal_z;
        this.colour_r = from.colour_r;
        this.colour_g = from.colour_g;
        this.colour_b = from.colour_b;
        this.colour_a = from.colour_a;
        this.tex_u = from.tex_u;
        this.tex_v = from.tex_v;
        this.light_block = from.light_block;
        this.light_sky = from.light_sky;
        return this;
    }

    public void toBakedBlock(int[] data, int offset) {
        data[offset++] = Float.floatToRawIntBits(this.position_x);
        data[offset++] = Float.floatToRawIntBits(this.position_y);
        data[offset++] = Float.floatToRawIntBits(this.position_z);
        data[offset++] = this.colourRGBA();
        data[offset++] = Float.floatToRawIntBits(this.tex_u);
        data[offset++] = Float.floatToRawIntBits(this.tex_v);
        data[offset++] = this.lightc();
        data[offset++] = this.normalToPackedInt();
    }

    public void toBakedItem(int[] data, int offset) {
        data[offset++] = Float.floatToRawIntBits(this.position_x);
        data[offset++] = Float.floatToRawIntBits(this.position_y);
        data[offset++] = Float.floatToRawIntBits(this.position_z);
        data[offset++] = this.colourRGBA();
        data[offset++] = Float.floatToRawIntBits(this.tex_u);
        data[offset++] = Float.floatToRawIntBits(this.tex_v);
        data[offset++] = this.normalToPackedInt();
    }

    public void fromBakedBlock(int[] data, int offset) {
        this.position_x = Float.intBitsToFloat(data[offset + 0]);
        this.position_y = Float.intBitsToFloat(data[offset + 1]);
        this.position_z = Float.intBitsToFloat(data[offset + 2]);
        this.tex_u = Float.intBitsToFloat(data[offset + 4]);
        this.tex_v = Float.intBitsToFloat(data[offset + 5]);
        this.colouri(data[offset + 3]);
        this.lighti(data[offset + 6]);
        data[offset + 6] = this.normalToPackedInt();
    }

    public void fromBakedItem(int[] data, int offset) {
        this.position_x = Float.intBitsToFloat(data[offset + 0]);
        this.position_y = Float.intBitsToFloat(data[offset + 1]);
        this.position_z = Float.intBitsToFloat(data[offset + 2]);
        this.colouri(data[offset + 3]);
        this.tex_u = Float.intBitsToFloat(data[offset + 4]);
        this.tex_v = Float.intBitsToFloat(data[offset + 5]);
        this.normali(data[offset + 6]);
        this.lightf(1.0f, 1.0f);
    }

    public void fromBakedFormat(int[] data, class_293 format, int offset) {
        int o = offset;
        for (class_296 elem : format.method_1357()) {
            switch (elem.comp_2845()) {
                case field_1633: {
                    assert (elem.comp_2844() == class_296.class_297.field_1623);
                    this.position_x = Float.intBitsToFloat(data[o++]);
                    this.position_y = Float.intBitsToFloat(data[o++]);
                    this.position_z = Float.intBitsToFloat(data[o++]);
                    break;
                }
                case field_1632: {
                    assert (elem.comp_2844() == class_296.class_297.field_1624);
                    this.colouri(data[o++]);
                    break;
                }
                case field_1635: {
                    assert (elem.comp_2844() == class_296.class_297.field_1621);
                    this.normali(data[o++]);
                    break;
                }
                case field_1636: {
                    if (elem.comp_2843() == 0) {
                        this.tex_u = Float.intBitsToFloat(data[o++]);
                        this.tex_v = Float.intBitsToFloat(data[o++]);
                        break;
                    }
                    if (elem.comp_2843() != 1) break;
                    this.lighti(data[o++]);
                }
            }
        }
    }

    public void putData(int vertexIndex, QuadEmitter emitter) {
        emitter.pos(vertexIndex, this.position_x, this.position_y, this.position_z);
        emitter.spriteColor(vertexIndex, 0, this.colourBGRA());
        emitter.sprite(vertexIndex, 0, this.tex_u, this.tex_v);
        emitter.normal(vertexIndex, this.normal_x, this.normal_y, this.normal_z);
        emitter.lightmap(vertexIndex, this.lightc());
    }

    public void render(class_287 bb) {
        class_293 vf = ((BufferBuilderAccessor)bb).simplepipes_getFormat();
        if (vf == class_290.field_20888) {
            this.renderAsBlock(bb);
        } else {
            for (class_296 vfe : vf.method_1357()) {
                switch (vfe.comp_2845()) {
                    case field_1633: {
                        this.renderPosition(bb);
                        break;
                    }
                    case field_1635: {
                        this.renderNormal(bb);
                        break;
                    }
                    case field_1632: {
                        this.renderColour(bb);
                        break;
                    }
                    case field_1636: {
                        if (vfe.comp_2843() == 0) {
                            this.renderTex(bb);
                            break;
                        }
                        if (vfe.comp_2843() != 1) break;
                        this.renderLightMap(bb);
                        break;
                    }
                }
            }
        }
    }

    public void renderAsBlock(class_287 bb) {
        this.renderPosition(bb);
        this.renderColour(bb);
        this.renderTex(bb);
        this.renderLightMap(bb);
    }

    public void renderPosition(class_287 bb) {
        bb.method_22912(this.position_x, this.position_y, this.position_z);
    }

    public void renderNormal(class_287 bb) {
        bb.method_22914(this.normal_x, this.normal_y, this.normal_z);
    }

    public void renderColour(class_287 bb) {
        bb.method_1336((int)this.colour_r, (int)this.colour_g, (int)this.colour_b, (int)this.colour_a);
    }

    public void renderTex(class_287 bb) {
        bb.method_22913(this.tex_u, this.tex_v);
    }

    public void renderLightMap(class_287 bb) {
        bb.method_22913((float)(this.light_sky << 4), (float)(this.light_block << 4));
    }

    public MutableVertex positionv(Vector3f vec) {
        return this.positionf(vec.x, vec.y, vec.z);
    }

    public MutableVertex positionv(class_243 vec) {
        return this.positiond(vec.field_1352, vec.field_1351, vec.field_1350);
    }

    public MutableVertex positiond(double x, double y, double z) {
        return this.positionf((float)x, (float)y, (float)z);
    }

    public MutableVertex positionf(float x, float y, float z) {
        this.position_x = x;
        this.position_y = y;
        this.position_z = z;
        return this;
    }

    public Vector3f positionvf() {
        return new Vector3f(this.position_x, this.position_y, this.position_z);
    }

    public class_243 positionvd() {
        return new class_243((double)this.position_x, (double)this.position_y, (double)this.position_z);
    }

    public MutableVertex normalv(Vector3f vec) {
        return this.normalf(vec.x, vec.y, vec.z);
    }

    public MutableVertex normalf(float x, float y, float z) {
        this.normal_x = x;
        this.normal_y = y;
        this.normal_z = z;
        return this;
    }

    public MutableVertex normali(int combined) {
        this.normal_x = (combined >> 0 & 0xFF) / 127;
        this.normal_y = (combined >> 8 & 0xFF) / 127;
        this.normal_z = (combined >> 16 & 0xFF) / 127;
        return this;
    }

    public MutableVertex invertNormal() {
        return this.normalf(-this.normal_x, -this.normal_y, -this.normal_z);
    }

    public Vector3f normal() {
        return new Vector3f(this.normal_x, this.normal_y, this.normal_z);
    }

    public int normalToPackedInt() {
        return MutableVertex.normalAsByte(this.normal_x, 0) | MutableVertex.normalAsByte(this.normal_y, 8) | MutableVertex.normalAsByte(this.normal_z, 16);
    }

    private static int normalAsByte(float norm, int offset) {
        int as = (int)(norm * 127.0f);
        return as << offset;
    }

    public MutableVertex colourv(Vector4f vec) {
        return this.colourf(vec.x, vec.y, vec.z, vec.w);
    }

    public MutableVertex colourf(float r, float g, float b, float a) {
        return this.colouri((int)(r * 255.0f), (int)(g * 255.0f), (int)(b * 255.0f), (int)(a * 255.0f));
    }

    public MutableVertex colouri(int rgba) {
        return this.colouri(rgba, rgba >> 8, rgba >> 16, rgba >>> 24);
    }

    public MutableVertex colouri(int r, int g, int b, int a) {
        this.colour_r = (short)(r & 0xFF);
        this.colour_g = (short)(g & 0xFF);
        this.colour_b = (short)(b & 0xFF);
        this.colour_a = (short)(a & 0xFF);
        return this;
    }

    public Vector4f colourv() {
        return new Vector4f((float)this.colour_r / 255.0f, (float)this.colour_g / 255.0f, (float)this.colour_b / 255.0f, (float)this.colour_a / 255.0f);
    }

    public int colourRGBA() {
        int rgba = 0;
        rgba |= (this.colour_r & 0xFF) << 0;
        rgba |= (this.colour_g & 0xFF) << 8;
        rgba |= (this.colour_b & 0xFF) << 16;
        return rgba |= (this.colour_a & 0xFF) << 24;
    }

    public int colourABGR() {
        int rgba = 0;
        rgba |= (this.colour_r & 0xFF) << 24;
        rgba |= (this.colour_g & 0xFF) << 16;
        rgba |= (this.colour_b & 0xFF) << 8;
        return rgba |= (this.colour_a & 0xFF) << 0;
    }

    public int colourBGRA() {
        int rgba = 0;
        rgba |= (this.colour_a & 0xFF) << 24;
        rgba |= (this.colour_r & 0xFF) << 16;
        rgba |= (this.colour_g & 0xFF) << 8;
        return rgba |= (this.colour_b & 0xFF) << 0;
    }

    public MutableVertex multColourd(double d) {
        int m = (int)(d * 255.0);
        return this.multColouri(m);
    }

    public MutableVertex multColourd(double r, double g, double b, double a) {
        return this.multColouri((int)(r * 255.0), (int)(g * 255.0), (int)(b * 255.0), (int)(a * 255.0));
    }

    public MutableVertex multColouri(int by) {
        return this.multColouri(by, by, by, 255);
    }

    public MutableVertex multColouri(int r, int g, int b, int a) {
        this.colour_r = (short)(this.colour_r * r / 255);
        this.colour_g = (short)(this.colour_g * g / 255);
        this.colour_b = (short)(this.colour_b * b / 255);
        this.colour_a = (short)(this.colour_a * a / 255);
        return this;
    }

    public MutableVertex multShade() {
        return this.multColourd(MutableQuad.diffuseLight(this.normal_x, this.normal_y, this.normal_z));
    }

    public MutableVertex texFromSprite(class_1058 sprite) {
        this.tex_u = SpriteUtil.getU(sprite, this.tex_u);
        this.tex_v = SpriteUtil.getV(sprite, this.tex_v);
        return this;
    }

    public MutableVertex texv(class_241 vec) {
        return this.texf(vec.field_1343, vec.field_1342);
    }

    public MutableVertex texf(float u, float v) {
        this.tex_u = u;
        this.tex_v = v;
        return this;
    }

    public class_241 tex() {
        return new class_241(this.tex_u, this.tex_v);
    }

    public MutableVertex lightv(class_241 vec) {
        return this.lightf(vec.field_1343, vec.field_1342);
    }

    public MutableVertex lightf(float block, float sky) {
        return this.lighti((int)(block * 15.0f), (int)(sky * 15.0f));
    }

    public MutableVertex lighti(int combined) {
        return this.lighti(combined >> 4, combined >> 20);
    }

    public MutableVertex lighti(int block, int sky) {
        this.light_block = (byte)block;
        this.light_sky = (byte)sky;
        return this;
    }

    public MutableVertex maxLighti(int block, int sky) {
        return this.lighti(Math.max(block, this.light_block), Math.max(sky, this.light_sky));
    }

    public class_241 lightvf() {
        return new class_241((float)this.light_block * 15.0f, (float)this.light_sky * 15.0f);
    }

    public int lightc() {
        return this.light_block << 4 + this.light_sky << 20;
    }

    public int[] lighti() {
        return new int[]{this.light_block, this.light_sky};
    }

    public MutableVertex translatei(int x, int y, int z) {
        this.position_x += (float)x;
        this.position_y += (float)y;
        this.position_z += (float)z;
        return this;
    }

    public MutableVertex translatef(float x, float y, float z) {
        this.position_x += x;
        this.position_y += y;
        this.position_z += z;
        return this;
    }

    public MutableVertex translated(double x, double y, double z) {
        this.position_x = (float)((double)this.position_x + x);
        this.position_y = (float)((double)this.position_y + y);
        this.position_z = (float)((double)this.position_z + z);
        return this;
    }

    public MutableVertex translatevi(class_2382 vec) {
        return this.translatei(vec.method_10263(), vec.method_10264(), vec.method_10260());
    }

    public MutableVertex translatevd(class_243 vec) {
        return this.translated(vec.field_1352, vec.field_1351, vec.field_1350);
    }

    public MutableVertex scalef(float scale) {
        this.position_x *= scale;
        this.position_y *= scale;
        this.position_z *= scale;
        return this;
    }

    public MutableVertex scaled(double scale) {
        return this.scalef((float)scale);
    }

    public MutableVertex scalef(float x, float y, float z) {
        this.position_x *= x;
        this.position_y *= y;
        this.position_z *= z;
        return this;
    }

    public MutableVertex scaled(double x, double y, double z) {
        return this.scalef((float)x, (float)y, (float)z);
    }

    public void rotateX(float angle) {
        float cos = class_3532.method_15362((float)angle);
        float sin = class_3532.method_15374((float)angle);
        this.rotateDirectlyX(cos, sin);
    }

    public void rotateY(float angle) {
        float cos = class_3532.method_15362((float)angle);
        float sin = class_3532.method_15374((float)angle);
        this.rotateDirectlyY(cos, sin);
    }

    public void rotateZ(float angle) {
        float cos = class_3532.method_15362((float)angle);
        float sin = class_3532.method_15374((float)angle);
        this.rotateDirectlyZ(cos, sin);
    }

    public void rotateDirectlyX(float cos, float sin) {
        float y = this.position_y;
        float z = this.position_z;
        this.position_y = y * cos - z * sin;
        this.position_z = y * sin + z * cos;
    }

    public void rotateDirectlyY(float cos, float sin) {
        float x = this.position_x;
        float z = this.position_z;
        this.position_x = x * cos - z * sin;
        this.position_z = x * sin + z * cos;
    }

    public void rotateDirectlyZ(float cos, float sin) {
        float x = this.position_x;
        float y = this.position_y;
        this.position_x = x * cos + y * sin;
        this.position_y = x * -sin + y * cos;
    }

    public MutableVertex rotateX_90(float scale) {
        float ym = scale;
        float zm = -ym;
        float t = this.position_y * ym;
        this.position_y = this.position_z * zm;
        this.position_z = t;
        t = this.normal_y * ym;
        this.normal_y = this.normal_z * zm;
        this.normal_z = t;
        return this;
    }

    public MutableVertex rotateY_90(float scale) {
        float xm = scale;
        float zm = -xm;
        float t = this.position_x * xm;
        this.position_x = this.position_z * zm;
        this.position_z = t;
        t = this.normal_x * xm;
        this.normal_x = this.normal_z * zm;
        this.normal_z = t;
        return this;
    }

    public MutableVertex rotateZ_90(float scale) {
        float xm = scale;
        float ym = -xm;
        float t = this.position_x * xm;
        this.position_x = this.position_y * ym;
        this.position_y = t;
        t = this.normal_x * xm;
        this.normal_x = this.normal_y * ym;
        this.normal_y = t;
        return this;
    }

    public MutableVertex rotateX_180() {
        this.position_y = -this.position_y;
        this.position_z = -this.position_z;
        this.normal_y = -this.normal_y;
        this.normal_z = -this.normal_z;
        return this;
    }

    public MutableVertex rotateY_180() {
        this.position_x = -this.position_x;
        this.position_z = -this.position_z;
        this.normal_x = -this.normal_x;
        this.normal_z = -this.normal_z;
        return this;
    }

    public MutableVertex rotateZ_180() {
        this.position_x = -this.position_x;
        this.position_y = -this.position_y;
        this.normal_x = -this.normal_x;
        this.normal_y = -this.normal_y;
        return this;
    }
}

